/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.table;

import com.alipay.oceanbase.rpc.location.model.partition.ObPair;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObTableQuery;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObTableQueryRequest;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.syncquery.ObQueryOperationType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.syncquery.ObTableQueryAsyncRequest;
import com.alipay.oceanbase.rpc.stream.QueryResultSet;
import com.alipay.oceanbase.rpc.stream.async.ObTableQueryAsyncResultSet;
import com.alipay.oceanbase.rpc.stream.async.ObTableQueryAsyncStreamResult;
import com.alipay.oceanbase.rpc.table.AbstractTableQueryImpl;
import com.alipay.oceanbase.rpc.table.ObTable;
import com.alipay.oceanbase.rpc.table.ObTableParam;
import com.alipay.oceanbase.rpc.table.api.TableQuery;
import java.util.HashMap;

public class ObTableQueryAsyncImpl
extends AbstractTableQueryImpl {
    private String tableName;
    private ObTable table;
    private long sessionId;

    public ObTableQueryAsyncImpl(String tableName, ObTable table) {
        this.tableName = tableName;
        this.table = table;
        this.resetRequest();
    }

    private void resetRequest() {
        ObTableQueryAsyncRequest obTableQueryAsyncRequest = new ObTableQueryAsyncRequest();
        this.tableQuery = new ObTableQuery();
        ObTableQueryRequest obTableQueryRequest = new ObTableQueryRequest();
        obTableQueryRequest.setTableQuery(this.tableQuery);
        obTableQueryRequest.setTableName(this.tableName);
        obTableQueryRequest.setTableId(-1L);
        obTableQueryRequest.setPartitionId(0L);
        obTableQueryAsyncRequest.setObTableQueryRequest(obTableQueryRequest);
    }

    @Override
    public ObTableQuery getObTableQuery() {
        return this.tableQuery;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    public TableQuery getTableQuery() {
        return this;
    }

    public ObTable getTable() {
        return this.table;
    }

    @Override
    public QueryResultSet execute() throws Exception {
        return new QueryResultSet(new ObTableQueryAsyncResultSet(this));
    }

    public QueryResultSet execute(ObQueryOperationType type) throws Exception {
        HashMap<Long, ObPair<Long, ObTableParam>> partitionObTable = new HashMap<Long, ObPair<Long, ObTableParam>>();
        partitionObTable.put(0L, new ObPair<Long, ObTableParam>(0L, new ObTableParam(this.table)));
        ObTableQueryAsyncStreamResult obTableQueryAsyncStreamResult = new ObTableQueryAsyncStreamResult();
        obTableQueryAsyncStreamResult.setTableQuery(this.tableQuery);
        obTableQueryAsyncStreamResult.setEntityType(this.entityType);
        obTableQueryAsyncStreamResult.setTableName(this.tableName);
        obTableQueryAsyncStreamResult.setExpectant(partitionObTable);
        obTableQueryAsyncStreamResult.setOperationTimeout(this.operationTimeout);
        obTableQueryAsyncStreamResult.init(type, this.sessionId);
        QueryResultSet querySyncResultSet = new QueryResultSet(obTableQueryAsyncStreamResult);
        boolean hasMore = !obTableQueryAsyncStreamResult.isEnd();
        querySyncResultSet.setHasMore(hasMore);
        querySyncResultSet.setSessionId(obTableQueryAsyncStreamResult.getSessionId());
        this.sessionId = obTableQueryAsyncStreamResult.getSessionId();
        return querySyncResultSet;
    }

    @Override
    public QueryResultSet executeInit(ObPair<Long, ObTableParam> entry) throws Exception {
        return this.execute(ObQueryOperationType.QUERY_START);
    }

    @Override
    public QueryResultSet executeNext(ObPair<Long, ObTableParam> entry) throws Exception {
        return this.execute(ObQueryOperationType.QUERY_NEXT);
    }

    @Override
    public TableQuery setKeys(String ... keys) {
        throw new IllegalArgumentException("Not needed");
    }

    @Override
    public void clear() {
    }
}

