/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.util;

import com.alipay.oceanbase.rpc.util.Serialization;
import java.util.ArrayList;

public class ObBytesString
implements Comparable<ObBytesString> {
    public byte[] bytes;

    public ObBytesString() {
        this.bytes = new byte[0];
    }

    public ObBytesString(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("ObBytesString bytes can not be null ");
        }
        this.bytes = bytes;
    }

    public ObBytesString(String str) {
        if (str == null) {
            throw new IllegalArgumentException("ObBytesString str can not be null ");
        }
        this.bytes = Serialization.strToBytes(str);
    }

    public int length() {
        return this.bytes.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObBytesString that = (ObBytesString)o;
        return this.compare(this.bytes, that.bytes) == 0;
    }

    @Override
    public int compareTo(ObBytesString another) {
        return this.compare(this.bytes, another.bytes);
    }

    private int compare(byte[] s, byte[] t) {
        int len1 = s.length;
        int len2 = t.length;
        int lim = Math.min(len1, len2);
        for (int k = 0; k < lim; ++k) {
            byte c1 = s[k];
            byte c2 = t[k];
            if (c1 == c2) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    public ObBytesString[] split(byte delim) {
        ArrayList<ObBytesString> list = new ArrayList<ObBytesString>();
        int start = 0;
        for (int i = 0; i < this.bytes.length; ++i) {
            if (this.bytes[i] != delim) continue;
            byte[] data = new byte[i - start];
            System.arraycopy(this.bytes, start, data, 0, data.length);
            ObBytesString str = new ObBytesString(data);
            list.add(str);
            start = i + 1;
        }
        if (start < this.bytes.length) {
            byte[] data = new byte[this.bytes.length - start];
            System.arraycopy(this.bytes, start, data, 0, data.length);
            ObBytesString str = new ObBytesString(data);
            list.add(str);
        }
        return list.toArray(new ObBytesString[0]);
    }
}

