/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.util;

import com.alipay.oceanbase.rpc.bolt.protocol.ObTablePacket;
import com.alipay.oceanbase.rpc.bolt.transport.ObTableConnection;
import com.alipay.oceanbase.rpc.protocol.payload.ObPayload;
import com.alipay.oceanbase.rpc.table.ObTable;

public class TraceUtil {
    public static String formatTraceMessage(ObTableConnection conn, ObPayload payload) {
        return TraceUtil.formatTraceMessage(conn, payload, "");
    }

    public static String formatTraceMessage(ObTableConnection conn, ObPayload payload, String msg) {
        return String.format("[Y%X-%016X] server [%s:%d] %s", payload.getUniqueId(), payload.getSequence(), conn.getObTable().getIp(), conn.getObTable().getPort(), msg);
    }

    public static String formatTraceMessage(ObTableConnection conn, ObTablePacket packet) {
        return TraceUtil.formatTraceMessage(conn, packet, "");
    }

    public static String formatTraceMessage(ObTableConnection conn, ObTablePacket packet, String msg) {
        return String.format("[Y%X-%016X] server [%s:%d] %s", packet.getHeader().getTraceId0(), packet.getHeader().getTraceId1(), conn.getObTable().getIp(), conn.getObTable().getPort(), msg);
    }

    public static String formatIpPort(ObTable obTable) {
        return String.format("server [%s:%d]", obTable.getIp(), obTable.getPort());
    }

    public static String formatTraceMessage(ObPayload payload) {
        return String.format("[Y%X-%016X]", payload.getUniqueId(), payload.getSequence());
    }
}

