/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.cloud.amazon;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.PropertiesCredentials;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.Address;
import com.amazonaws.services.ec2.model.DescribeAddressesResult;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.Reservation;
import com.tangosol.net.AddressProvider;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EC2AddressProvider
implements AddressProvider {
    private static final Logger logger = Logger.getLogger(EC2AddressProvider.class.getName());
    private List<InetSocketAddress> wkaAddressList;
    private Iterator<InetSocketAddress> wkaIterator;

    public EC2AddressProvider() throws IOException {
        if (logger.isLoggable(Level.CONFIG)) {
            logger.log(Level.CONFIG, "Initializing WKA list from EC2 Elastic IP to instance mapping.");
        }
        this.wkaAddressList = this.generateWKAList((AmazonEC2)new AmazonEC2Client(this.determineCredentials()));
        this.wkaIterator = this.wkaAddressList.iterator();
    }

    protected EC2AddressProvider(String dummyDifferentiator) {
    }

    protected List<InetSocketAddress> generateWKAList(AmazonEC2 ec2) {
        String portString = System.getProperty("tangosol.coherence.ec2addressprovider.port", "8088");
        int wkaPort = Integer.parseInt(portString);
        ArrayList<InetSocketAddress> resultList = new ArrayList<InetSocketAddress>();
        DescribeInstancesResult describeInstancesResult = ec2.describeInstances();
        List reservations = describeInstancesResult.getReservations();
        HashSet<Instance> instances = new HashSet<Instance>();
        for (Reservation reservation : reservations) {
            instances.addAll(reservation.getInstances());
            if (!logger.isLoggable(Level.CONFIG)) continue;
            logger.log(Level.CONFIG, "Examining EC2 reservation:" + reservation);
        }
        this.logAllInstances(instances);
        DescribeAddressesResult elasticAddressesResult = ec2.describeAddresses();
        if (elasticAddressesResult != null) {
            for (Address elasticAddress : elasticAddressesResult.getAddresses()) {
                for (Instance instance : instances) {
                    if (!instance.getInstanceId().equals(elasticAddress.getInstanceId())) continue;
                    if (logger.isLoggable(Level.CONFIG)) {
                        logger.log(Level.CONFIG, "EC2AddressProvider - adding {0} from instance {1} to WKA list", new Object[]{instance.getPrivateIpAddress(), instance});
                    }
                    resultList.add(new InetSocketAddress(instance.getPrivateIpAddress(), wkaPort));
                }
            }
            if (resultList.size() == 0) {
                throw new RuntimeException("The EC2AddressProvider could not find any instance mapped to an Elastic IP");
            }
        } else {
            throw new RuntimeException("The EC2AddressProvider could not enumerate the Elastic IP Addresses");
        }
        return resultList;
    }

    protected AWSCredentials determineCredentials() throws IOException {
        String accessKey = System.getProperty("tangosol.coherence.ec2addressprovider.accesskey");
        String secretKey = System.getProperty("tangosol.coherence.ec2addressprovider.secretkey");
        if (accessKey == null || secretKey == null || accessKey.equals("") || secretKey.equals("")) {
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "No EC2AddressProvider credential system properties provided.");
            }
            String propertyResource = System.getProperty("tangosol.coherence.ec2addressprovider.propertyfile", "AwsCredentials.properties");
            InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(propertyResource);
            if (stream != null) {
                return new PropertiesCredentials(stream);
            }
            throw new RuntimeException("The EC2AddressProvider could not find any credentials, neither as system properties, nor as " + propertyResource + " resource");
        }
        return new BasicAWSCredentials(accessKey, secretKey);
    }

    private void logAllInstances(Set<Instance> instances) {
        if (logger.isLoggable(Level.CONFIG)) {
            logger.log(Level.CONFIG, "The following instances were found:");
            Iterator<Instance> instIter = instances.iterator();
            while (instIter.hasNext()) {
                logger.log(Level.CONFIG, "EC2 instance:", instIter.next());
            }
        }
    }

    public void accept() {
    }

    public InetSocketAddress getNextAddress() {
        if (this.wkaIterator.hasNext()) {
            InetSocketAddress address = this.wkaIterator.next();
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Returning WKA address {0}", address);
            }
            return address;
        }
        this.wkaIterator = this.wkaAddressList.iterator();
        return null;
    }

    public void reject(Throwable exception) {
    }
}

