/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.applications;

import com.oracle.coherence.common.applications.Application;
import com.oracle.coherence.common.applications.ApplicationConsole;
import com.oracle.coherence.common.applications.SystemApplicationConsole;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import java.util.Properties;

@Deprecated
public abstract class AbstractApplication
implements Application {
    private final Process process;
    private String name;
    private final ApplicationConsole console;
    private Properties environmentVariables;
    private Thread ioThread;
    private long pid = -1L;

    public AbstractApplication(Process process, String name, ApplicationConsole console, Properties environmentVariables) {
        this.process = process;
        this.name = name;
        this.console = console == null ? new SystemApplicationConsole() : console;
        this.environmentVariables = environmentVariables;
        this.pid = this.determinePID(process);
        this.ioThread = new Thread(new Runnable(){

            @Override
            public void run() {
                long lineNumber = 1L;
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(new BufferedInputStream(AbstractApplication.this.process.getInputStream())));
                    while ((line = reader.readLine()) != null) {
                        AbstractApplication.this.console.printf("[%s%s] %4d: %s\n", AbstractApplication.this.name, AbstractApplication.this.pid < 0L ? "" : "-" + AbstractApplication.this.pid, lineNumber++, line);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                AbstractApplication.this.console.printf("[%s] %4d: (terminated)\n", AbstractApplication.this.name, lineNumber++);
            }
        });
        this.ioThread.setDaemon(true);
        this.ioThread.start();
    }

    @Override
    public Properties getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void destroy() {
        this.ioThread.interrupt();
        try {
            this.process.getInputStream().close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.process.getOutputStream().close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.process.getErrorStream().close();
        }
        catch (IOException e) {
            // empty catch block
        }
        this.process.destroy();
        try {
            this.process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public long getPid() {
        return this.pid;
    }

    private long determinePID(Process p) {
        long pid = -1L;
        try {
            if (p.getClass().getSimpleName().equals("UNIXProcess")) {
                Class<?> clazz = p.getClass();
                Field pidF = clazz.getDeclaredField("pid");
                pidF.setAccessible(true);
                Object oPid = pidF.get(p);
                if (oPid instanceof Number) {
                    pid = ((Number)oPid).longValue();
                } else if (oPid instanceof String) {
                    pid = Long.parseLong((String)oPid);
                }
            } else {
                RuntimeMXBean rtb = ManagementFactory.getRuntimeMXBean();
                String sProcess = rtb.getName();
                int iPID = sProcess.indexOf(64);
                if (iPID > 0) {
                    String sPID = sProcess.substring(0, iPID);
                    pid = Long.parseLong(sPID);
                }
            }
        }
        catch (SecurityException e) {
        }
        catch (NoSuchFieldException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
        return pid;
    }
}

