/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.applications;

import com.oracle.coherence.common.applications.AbstractApplicationBuilder;
import com.oracle.coherence.common.applications.ApplicationConsole;
import com.oracle.coherence.common.applications.JavaApplication;
import com.oracle.coherence.common.applications.JavaApplicationBuilder;
import com.oracle.coherence.common.applications.NullApplicationConsole;
import com.oracle.coherence.common.applications.PropertiesBuilder;
import com.oracle.coherence.common.applications.SystemApplicationConsole;
import com.oracle.coherence.common.network.AvailablePortIterator;
import com.tangosol.util.UUID;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;

@Deprecated
public abstract class AbstractJavaApplicationBuilder<A extends JavaApplication, B extends JavaApplicationBuilder<A, ?>>
extends AbstractApplicationBuilder<A, B>
implements JavaApplicationBuilder<A, B> {
    public static final String SUN_MANAGEMENT_JMXREMOTE = "com.sun.management.jmxremote";
    public static final String SUN_MANAGEMENT_JMXREMOTE_PORT = "com.sun.management.jmxremote.port";
    public static final String SUN_MANAGEMENT_JMXREMOTE_AUTHENTICATE = "com.sun.management.jmxremote.authenticate";
    public static final String SUN_MANAGEMENT_JMXREMOTE_SSL = "com.sun.management.jmxremote.ssl";
    public static final String JAVA_RMI_SERVER_HOSTNAME = "java.rmi.server.hostname";
    private String applicationClassName;
    private String classPath;
    private ArrayList<String> options;
    private PropertiesBuilder systemPropertiesBuilder;

    public AbstractJavaApplicationBuilder(String applicationClassName) {
        this(applicationClassName, System.getProperty("java.class.path"));
    }

    public AbstractJavaApplicationBuilder(String applicationClassName, String classPath) {
        this.applicationClassName = applicationClassName;
        this.classPath = classPath;
        this.options = new ArrayList();
        this.systemPropertiesBuilder = new PropertiesBuilder();
    }

    @Override
    public PropertiesBuilder getSystemPropertiesBuilder() {
        return this.systemPropertiesBuilder;
    }

    public B setClassPath(String classPath) {
        this.classPath = classPath;
        return (B)this;
    }

    public B setSystemProperty(String name, Object value) {
        this.systemPropertiesBuilder.setProperty(name, value);
        return (B)this;
    }

    public B setDefaultSystemProperty(String name, Object value) {
        this.systemPropertiesBuilder.setDefaultProperty(name, value);
        return (B)this;
    }

    public B setSystemProperties(PropertiesBuilder systemProperties) {
        this.systemPropertiesBuilder.addProperties(systemProperties);
        return (B)this;
    }

    public void addOption(String option) {
        this.options.add(option.startsWith("-") ? option.substring(1) : option);
    }

    public B setOption(String option) {
        this.addOption(option);
        return (B)this;
    }

    public B setJMXSupport(boolean enabled) {
        if (enabled) {
            this.setDefaultSystemProperty(SUN_MANAGEMENT_JMXREMOTE_PORT, 9000);
            this.setDefaultSystemProperty(SUN_MANAGEMENT_JMXREMOTE, "");
            this.setDefaultSystemProperty(SUN_MANAGEMENT_JMXREMOTE_AUTHENTICATE, false);
            this.setDefaultSystemProperty(SUN_MANAGEMENT_JMXREMOTE_SSL, false);
            this.setDefaultSystemProperty(JAVA_RMI_SERVER_HOSTNAME, "localhost");
            return (B)this;
        }
        this.systemPropertiesBuilder.removeProperty(SUN_MANAGEMENT_JMXREMOTE);
        this.systemPropertiesBuilder.removeProperty(SUN_MANAGEMENT_JMXREMOTE_PORT);
        this.systemPropertiesBuilder.removeProperty(SUN_MANAGEMENT_JMXREMOTE_AUTHENTICATE);
        this.systemPropertiesBuilder.removeProperty(SUN_MANAGEMENT_JMXREMOTE_SSL);
        this.systemPropertiesBuilder.removeProperty(JAVA_RMI_SERVER_HOSTNAME);
        return (B)this;
    }

    public B setJMXAuthentication(boolean enabled) {
        return this.setDefaultSystemProperty(SUN_MANAGEMENT_JMXREMOTE_AUTHENTICATE, enabled);
    }

    public B setJMXPort(int port) {
        return this.setSystemProperty(SUN_MANAGEMENT_JMXREMOTE_PORT, port);
    }

    public B setJMXPort(AvailablePortIterator portIterator) {
        return this.setSystemProperty(SUN_MANAGEMENT_JMXREMOTE_PORT, portIterator);
    }

    public B setRMIServerHostName(String rmiServerHostName) {
        this.setDefaultSystemProperty(JAVA_RMI_SERVER_HOSTNAME, rmiServerHostName);
        return (B)this;
    }

    @Override
    public A realize(B defaultBuilder, String name, ApplicationConsole console) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder("java");
        processBuilder.redirectErrorStream(true);
        for (String option : this.options) {
            processBuilder.command().add("-" + option);
        }
        Properties environmentVariables = this.getEnvironmentVariablesBuilder().realize(defaultBuilder == null ? null : defaultBuilder.getEnvironmentVariablesBuilder());
        processBuilder.environment().clear();
        for (String variableName : environmentVariables.stringPropertyNames()) {
            processBuilder.environment().put(variableName, environmentVariables.getProperty(variableName));
        }
        processBuilder.environment().put("CLASSPATH", this.classPath);
        Properties systemProperties = this.systemPropertiesBuilder.realize(defaultBuilder == null ? null : defaultBuilder.getSystemPropertiesBuilder());
        for (String propertyName : systemProperties.stringPropertyNames()) {
            String propertyValue = systemProperties.getProperty(propertyName);
            processBuilder.command().add("-D" + propertyName + (propertyValue.isEmpty() ? "" : "=" + propertyValue));
        }
        processBuilder.command().add(this.applicationClassName);
        for (String argument : this.getArguments()) {
            processBuilder.command().add(argument);
        }
        A application = this.createJavaApplication(processBuilder.start(), name, console, environmentVariables, systemProperties);
        if (this.getApplicationPreparer() != null) {
            this.getApplicationPreparer().prepare(application);
        }
        return application;
    }

    protected abstract A createJavaApplication(Process var1, String var2, ApplicationConsole var3, Properties var4, Properties var5);

    public A realize() throws IOException {
        return this.realize((B)null, new UUID().toString(), (ApplicationConsole)new NullApplicationConsole());
    }

    public A realize(String name, ApplicationConsole console) throws IOException {
        return this.realize((B)null, name, console);
    }

    public A realize(String name) throws IOException {
        return this.realize((B)null, name, (ApplicationConsole)new SystemApplicationConsole());
    }
}

