/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.applications;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Properties;

public class Runner {
    public static void main(String[] arguments) {
        block17: {
            System.out.println("-----------------------------------------------------------");
            System.out.println("Oracle Java Application Runner");
            System.out.println("Copyright (c) 2013. Oracle Corporation");
            System.out.println("-----------------------------------------------------------");
            System.out.println();
            if (arguments.length == 1) {
                String propertiesFileName = arguments[0].trim();
                if (!propertiesFileName.endsWith(".properties")) {
                    System.out.printf("WARNING: The specified application properties file [%s] doesn't end in .properties\n", propertiesFileName);
                }
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(ClassLoader.getSystemResourceAsStream(propertiesFileName)));
                    Properties applicationProperties = new Properties();
                    applicationProperties.load(reader);
                    reader.close();
                    String applicationClassName = applicationProperties.getProperty("Main-Class");
                    if (applicationClassName == null || applicationClassName.trim().isEmpty()) {
                        System.out.println("ERROR: Failed to load the Main-Class for the application as it is either undefined or empty");
                        break block17;
                    }
                    try {
                        String applicationDescription;
                        Class<?> applicationClass = Class.forName(applicationClassName);
                        ArrayList<String> applicationArguments = new ArrayList<String>();
                        for (String propertyName : applicationProperties.stringPropertyNames()) {
                            if (propertyName.startsWith("System-Property")) {
                                String propertyDefinition = applicationProperties.getProperty(propertyName);
                                String[] propertyParts = propertyDefinition.split("=");
                                if (propertyParts.length == 2) {
                                    System.setProperty(propertyParts[0], propertyParts[1]);
                                } else {
                                    throw new IllegalArgumentException(String.format("ERROR: Invalid Property Value for [%s=%s].  Should be of the form: System-PropertyN=-Dproperty.name=property.value\n", propertyName, propertyDefinition));
                                }
                            }
                            if (!propertyName.startsWith("Argument")) continue;
                            try {
                                String indexNumber = propertyName.substring("Argument".length());
                                Integer index = Integer.parseInt(indexNumber);
                                applicationArguments.set(index, applicationProperties.getProperty(propertyName));
                            }
                            catch (Exception e) {
                                throw new IllegalArgumentException(String.format("ERROR: Invalid Argument Index for [%s=%s].  Should be of the form: ArgumentN=value (where N is an integer)\n", propertyName, applicationProperties.getProperty(propertyName)), e);
                            }
                        }
                        String applicationName = applicationProperties.containsKey("Application-Name") ? applicationProperties.getProperty("Application-Name").trim() : null;
                        String string = applicationDescription = applicationProperties.containsKey("Application-Description") ? applicationProperties.getProperty("Application-Description").trim() : null;
                        if (applicationName != null) {
                            System.out.printf("Application Name        : %s\n", applicationName);
                        }
                        if (applicationDescription != null) {
                            System.out.printf("Application Description : %s\n", applicationDescription);
                        }
                        System.out.printf("Application Class       : %s\n", applicationClass);
                        System.out.printf("With Arguments          : %s\n", applicationArguments == null || applicationArguments.size() == 0 ? "(no arguments)" : applicationArguments);
                        System.out.printf("Using System Properties : %s\n", System.getProperties());
                        System.out.println();
                        String[] mainArguments = new String[applicationArguments.size()];
                        for (int i = 0; i < mainArguments.length; ++i) {
                            String applicationArgument = (String)applicationArguments.get(i);
                            mainArguments[i] = applicationArgument == null ? "" : applicationArgument;
                        }
                        Method mainMethod = applicationClass.getMethod("main", String[].class);
                        mainMethod.invoke(null, new Object[]{mainArguments});
                    }
                    catch (Exception e) {
                        System.out.printf("ERROR: Failed to load and execute the Main-Class [%s] due to:\n%s", applicationClassName, e);
                    }
                }
                catch (Exception e) {
                    System.out.printf("ERROR: Unable to loaded the application properties file [%s] due to:\n%s", propertiesFileName, e);
                }
            } else {
                System.out.println("Oracle Java Application Runner requires a single parameter, specifying a .properties file on the classpath");
            }
        }
    }
}

