/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.backingmaplisteners;

import com.oracle.coherence.common.backingmaplisteners.Cause;
import com.oracle.coherence.common.backingmaplisteners.MultiplexingBackingMapListener;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.cache.CacheEvent;
import com.tangosol.util.Binary;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MultiplexingMapListener;
import com.tangosol.util.ObservableMap;

public abstract class AbstractMultiplexingBackingMapListener
extends MultiplexingMapListener
implements MultiplexingBackingMapListener {
    private BackingMapManagerContext context;

    public AbstractMultiplexingBackingMapListener(BackingMapManagerContext context) {
        this.context = context;
    }

    public BackingMapManagerContext getContext() {
        return this.context;
    }

    protected boolean isDecorationRemoved(MapEvent evt, int nDecorationId) {
        Binary binOldValue = (Binary)evt.getOldValue();
        Binary binNewValue = (Binary)evt.getNewValue();
        BackingMapManagerContext ctx = this.getContext();
        return binOldValue != null && ctx.isInternalValueDecorated((Object)binOldValue, nDecorationId) && !ctx.isInternalValueDecorated((Object)binNewValue, nDecorationId);
    }

    protected final void onMapEvent(MapEvent mapEvent) {
        Cause cause = this.context.isKeyOwned(mapEvent.getKey()) ? (this.isDecorationRemoved(mapEvent, 2) ? Cause.StoreCompleted : (mapEvent instanceof CacheEvent && ((CacheEvent)mapEvent).isSynthetic() ? Cause.Eviction : Cause.Regular)) : Cause.PartitionManagement;
        this.onBackingMapEvent(new LazyMapEvent(this.context, mapEvent.getMap(), mapEvent.getId(), mapEvent.getKey(), mapEvent.getOldValue(), mapEvent.getNewValue()), cause);
    }

    private static class LazyMapEvent
    extends MapEvent {
        private BackingMapManagerContext backingMapManagerContext;

        LazyMapEvent(BackingMapManagerContext backingMapManagerContext, ObservableMap observableMap, int id, Object key, Object oldValue, Object newValue) {
            super(observableMap, id, key, oldValue, newValue);
            this.backingMapManagerContext = backingMapManagerContext;
        }

        public Object getKey() {
            if (this.m_oKey instanceof Binary) {
                this.m_oKey = this.backingMapManagerContext.getKeyFromInternalConverter().convert(this.m_oKey);
            }
            return this.m_oKey;
        }

        public Object getOldValue() {
            if (this.m_oValueOld instanceof Binary) {
                this.m_oValueOld = this.backingMapManagerContext.getValueFromInternalConverter().convert(this.m_oValueOld);
            }
            return this.m_oValueOld;
        }

        public Object getNewValue() {
            if (this.m_oValueNew instanceof Binary) {
                this.m_oValueNew = this.backingMapManagerContext.getValueFromInternalConverter().convert(this.m_oValueNew);
            }
            return this.m_oValueNew;
        }

        public String toString() {
            return String.format("LazyEventMap{%s}", super.toString());
        }
    }
}

