/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.builders;

import com.oracle.coherence.common.builders.AbstractClassLoaderAwareParameterizedBuilder;
import com.oracle.coherence.common.builders.ParameterizedBuilder;
import com.oracle.coherence.common.builders.ReflectiveBuilder;
import com.oracle.coherence.common.util.ReflectionHelper;
import com.oracle.coherence.common.util.Value;
import com.oracle.coherence.configuration.Mandatory;
import com.oracle.coherence.configuration.Property;
import com.oracle.coherence.configuration.SubType;
import com.oracle.coherence.configuration.Type;
import com.oracle.coherence.configuration.expressions.Expression;
import com.oracle.coherence.configuration.parameters.EmptyParameterProvider;
import com.oracle.coherence.configuration.parameters.Parameter;
import com.oracle.coherence.configuration.parameters.ParameterProvider;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassSchemeBasedParameterizedBuilder
extends AbstractClassLoaderAwareParameterizedBuilder<Object>
implements ExternalizableLite,
PortableObject {
    private static final Logger logger = Logger.getLogger(ClassSchemeBasedParameterizedBuilder.class.getName());
    private Expression className;
    private ParameterProvider parameters = new EmptyParameterProvider();

    public Expression getClassName() {
        return this.className;
    }

    @Property(value="class-name")
    @Type(value=Expression.class)
    @SubType(value=String.class)
    @Mandatory
    public void setClassName(Expression className) {
        this.className = className;
    }

    public ParameterProvider getParameters() {
        return this.parameters;
    }

    @Property(value="init-params")
    @Type(value=ParameterProvider.class)
    public void setParameters(ParameterProvider parameters) {
        this.parameters = parameters;
    }

    @Override
    public boolean realizesClassOf(Class<?> otherClazz, ParameterProvider parameterProvider) {
        try {
            Class<?> clazz = Class.forName(this.className.evaluate(parameterProvider).getString(), false, this.getContextClassLoader());
            Constructor<?> compatibleConstructor = null;
            for (Constructor<?> constructor : clazz.getConstructors()) {
                if (constructor.getParameterTypes().length != this.getParameters().size()) continue;
                compatibleConstructor = constructor;
                break;
            }
            return compatibleConstructor == null ? false : otherClazz.isAssignableFrom(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, String.format("Class %s not found while attempting to determine type information of a ReflectiveScheme", this.className), classNotFoundException);
            }
            return false;
        }
    }

    @Override
    public Object realize(ParameterProvider parameterProvider) {
        try {
            String resolvedClassName = this.className.evaluate(parameterProvider).getString();
            Class<?> clazz = this.getContextClassLoader().loadClass(resolvedClassName);
            Constructor<?> compatibleConstructor = null;
            Object[] constructorParameters = this.parameters.size() == 0 ? null : new Object[this.parameters.size()];
            Constructor<?>[] constructors = clazz.getConstructors();
            for (int i = 0; i < constructors.length && compatibleConstructor == null; ++i) {
                if (constructors[i].getParameterTypes().length != this.parameters.size()) continue;
                Class<?>[] constructorParameterTypes = constructors[i].getParameterTypes();
                boolean isCompatible = true;
                try {
                    int j = 0;
                    for (Parameter proposedParameter : this.parameters) {
                        Value valProposed = proposedParameter.evaluate(parameterProvider);
                        Class<?> clzParameter = constructorParameterTypes[j];
                        if (valProposed.isNull()) {
                            constructorParameters[j] = null;
                        } else {
                            Class<?> clzProposed = valProposed.getObject().getClass();
                            if (clzParameter.isAssignableFrom(clzProposed) || clzParameter.isPrimitive() && ReflectionHelper.isAssignablePrimitive(clzParameter, clzProposed)) {
                                constructorParameters[j] = valProposed.getObject();
                            } else if (valProposed.getObject() instanceof ParameterizedBuilder && ((ReflectiveBuilder)valProposed.getObject()).realizesClassOf(clzParameter, parameterProvider)) {
                                constructorParameters[j] = ((ParameterizedBuilder)valProposed.getObject()).realize(parameterProvider);
                            } else if (proposedParameter.isStronglyTyped()) {
                                clzProposed = this.getContextClassLoader().loadClass(proposedParameter.getType());
                                if (clzParameter.isAssignableFrom(clzProposed) || clzParameter.isPrimitive() && ReflectionHelper.isAssignablePrimitive(clzParameter, clzProposed)) {
                                    constructorParameters[j] = valProposed.getValue(clzProposed);
                                } else {
                                    isCompatible = false;
                                }
                            } else {
                                constructorParameters[j] = valProposed.getValue(clzParameter);
                            }
                        }
                        ++j;
                    }
                }
                catch (Exception exception) {
                    isCompatible = false;
                }
                if (!isCompatible) continue;
                compatibleConstructor = constructors[i];
            }
            if (compatibleConstructor == null) {
                throw new NoSuchMethodException(String.format("Unable to find a compatible constructor for %s with the parameters %s", resolvedClassName, this.parameters));
            }
            return compatibleConstructor.newInstance(constructorParameters);
        }
        catch (Exception exception) {
            throw Base.ensureRuntimeException((Throwable)exception);
        }
    }

    public void readExternal(DataInput in) throws IOException {
        this.className = (Expression)ExternalizableHelper.readObject((DataInput)in, (ClassLoader)this.getClass().getClassLoader());
        this.parameters = (ParameterProvider)ExternalizableHelper.readObject((DataInput)in, (ClassLoader)this.getClass().getClassLoader());
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.className);
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.parameters);
    }

    public void readExternal(PofReader reader) throws IOException {
        this.className = (Expression)reader.readObject(1);
        this.parameters = (ParameterProvider)reader.readObject(2);
    }

    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeObject(1, (Object)this.className);
        writer.writeObject(2, (Object)this.parameters);
    }

    public String toString() {
        return String.format("ClassSchemeBasedParameterizedBuilder{className=%s, parameters=%s}", this.className, this.parameters);
    }
}

