/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.builders;

import com.oracle.coherence.common.builders.ParameterizedBuilder;
import com.oracle.coherence.configuration.Mandatory;
import com.oracle.coherence.configuration.Property;
import com.oracle.coherence.configuration.SubType;
import com.oracle.coherence.configuration.Type;
import com.oracle.coherence.configuration.expressions.Expression;
import com.oracle.coherence.configuration.parameters.ParameterProvider;
import com.oracle.coherence.configuration.parameters.SystemPropertyParameterProvider;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class JndiBasedParameterizedBuilder
implements ParameterizedBuilder<Object>,
PortableObject,
ExternalizableLite {
    private static final Logger logger = Logger.getLogger(JndiBasedParameterizedBuilder.class.getName());
    private Expression m_exprResourceName;
    private ParameterProvider m_ParameterProvider = SystemPropertyParameterProvider.INSTANCE;

    public Expression getResourceNameExpression() {
        return this.m_exprResourceName;
    }

    @Property(value="resource-name")
    @Mandatory
    @Type(value=Expression.class)
    @SubType(value=String.class)
    public void setResourceNameExpression(Expression exprResourceName) {
        this.m_exprResourceName = exprResourceName;
    }

    public ParameterProvider getParameterProvider() {
        return this.m_ParameterProvider;
    }

    @Property(value="init-params")
    @Type(value=ParameterProvider.class)
    public void setParameterProvider(ParameterProvider parameterProvider) {
        this.m_ParameterProvider = parameterProvider;
    }

    @Override
    public boolean realizesClassOf(Class<?> clazz, ParameterProvider parameterProvider) {
        return clazz.isAssignableFrom(this.realize(parameterProvider).getClass());
    }

    @Override
    public Object realize(ParameterProvider parameterProvider) {
        try {
            String resourceName = this.m_exprResourceName.evaluate(parameterProvider).getString();
            Hashtable env = new Hashtable(this.m_ParameterProvider.getParameters(parameterProvider));
            InitialContext initialContext = new InitialContext(env);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Looking up {0} using JNDI with the environment {1}", new Object[]{resourceName, env});
            }
            Object resource = initialContext.lookup(resourceName);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Found {0} using JNDI", resource);
            }
            return resource;
        }
        catch (NamingException e) {
            throw Base.ensureRuntimeException((Throwable)e, (String)("Unable to resolve the JNDI resource: " + this.m_exprResourceName.toString()));
        }
    }

    public void readExternal(DataInput in) throws IOException {
        this.m_exprResourceName = (Expression)ExternalizableHelper.readObject((DataInput)in, (ClassLoader)this.getClass().getClassLoader());
        this.m_ParameterProvider = (ParameterProvider)ExternalizableHelper.readObject((DataInput)in, (ClassLoader)this.getClass().getClassLoader());
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.m_exprResourceName);
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.m_ParameterProvider);
    }

    public void readExternal(PofReader reader) throws IOException {
        this.m_exprResourceName = (Expression)reader.readObject(1);
        this.m_ParameterProvider = (ParameterProvider)reader.readObject(2);
    }

    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeObject(1, (Object)this.m_exprResourceName);
        writer.writeObject(2, (Object)this.m_ParameterProvider);
    }

    public String toString() {
        return String.format("%s{resourceName=%s, parameters=%s}", this.getClass().getName(), this.m_exprResourceName, this.m_ParameterProvider);
    }
}

