/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.builders;

import com.oracle.coherence.common.builders.ParameterizedBuilder;
import com.oracle.coherence.configuration.expressions.Constant;
import com.oracle.coherence.configuration.expressions.Expression;
import com.oracle.coherence.configuration.parameters.ParameterProvider;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.Serializer;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class NamedCacheSerializerBuilder
implements ParameterizedBuilder<Serializer>,
ExternalizableLite,
PortableObject {
    private Expression m_exprCacheName;

    public NamedCacheSerializerBuilder() {
    }

    public NamedCacheSerializerBuilder(Expression exprCacheName) {
        this.m_exprCacheName = exprCacheName;
    }

    public NamedCacheSerializerBuilder(String cacheName) {
        this.m_exprCacheName = new Constant(cacheName);
    }

    @Override
    public Serializer realize(ParameterProvider parameterProvider) {
        return CacheFactory.getCache((String)this.m_exprCacheName.evaluate(parameterProvider).getString()).getCacheService().getSerializer();
    }

    @Override
    public boolean realizesClassOf(Class<?> clazz, ParameterProvider parameterProvider) {
        return clazz.isAssignableFrom(NamedCache.class);
    }

    public void readExternal(DataInput in) throws IOException {
        this.m_exprCacheName = (Expression)ExternalizableHelper.readObject((DataInput)in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.m_exprCacheName);
    }

    public void readExternal(PofReader reader) throws IOException {
        this.m_exprCacheName = (Expression)reader.readObject(1);
    }

    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeObject(1, (Object)this.m_exprCacheName);
    }
}

