/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.builders;

import com.oracle.coherence.common.builders.AbstractClassLoaderAwareParameterizedBuilder;
import com.oracle.coherence.common.builders.ParameterizedBuilder;
import com.oracle.coherence.common.builders.ReflectiveBuilder;
import com.oracle.coherence.common.util.ReflectionHelper;
import com.oracle.coherence.common.util.Value;
import com.oracle.coherence.configuration.Mandatory;
import com.oracle.coherence.configuration.Property;
import com.oracle.coherence.configuration.SubType;
import com.oracle.coherence.configuration.Type;
import com.oracle.coherence.configuration.expressions.Expression;
import com.oracle.coherence.configuration.parameters.EmptyParameterProvider;
import com.oracle.coherence.configuration.parameters.Parameter;
import com.oracle.coherence.configuration.parameters.ParameterProvider;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StaticFactoryClassSchemeBasedParameterizedBuilder
extends AbstractClassLoaderAwareParameterizedBuilder<Object>
implements ExternalizableLite,
PortableObject {
    private static final Logger logger = Logger.getLogger(StaticFactoryClassSchemeBasedParameterizedBuilder.class.getName());
    private Expression factoryClassName;
    private Expression factoryMethodName;
    private ParameterProvider parameters = new EmptyParameterProvider();

    public Expression getFactoryClassName() {
        return this.factoryClassName;
    }

    @Property(value="class-factory-name")
    @Type(value=Expression.class)
    @SubType(value=String.class)
    @Mandatory
    public void setFactoryClassName(Expression factoryClassName) {
        this.factoryClassName = factoryClassName;
    }

    public Expression getFactoryMethodName() {
        return this.factoryMethodName;
    }

    @Property(value="method-name")
    @Type(value=Expression.class)
    @SubType(value=String.class)
    @Mandatory
    public void setFactoryMethodName(Expression factoryMethodName) {
        this.factoryMethodName = factoryMethodName;
    }

    public ParameterProvider getParameters() {
        return this.parameters;
    }

    @Property(value="init-params")
    @Type(value=ParameterProvider.class)
    public void setParameters(ParameterProvider parameters) {
        this.parameters = parameters;
    }

    @Override
    public boolean realizesClassOf(Class<?> otherClazz, ParameterProvider parameterProvider) {
        try {
            Class<?> clazz = Class.forName(this.factoryClassName.evaluate(parameterProvider).getString(), false, this.getContextClassLoader());
            String methodName = this.factoryMethodName.evaluate(parameterProvider).getString();
            Method compatibleMethod = null;
            for (Method method : clazz.getMethods()) {
                if (!method.getName().equals(methodName) || !Modifier.isStatic(method.getModifiers()) || method.getReturnType() == null || method.getParameterTypes().length != this.parameters.size() || !otherClazz.isAssignableFrom(method.getReturnType())) continue;
                compatibleMethod = method;
                break;
            }
            return compatibleMethod != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, String.format("Class %s not found while attempting to determine type information of a ReflectiveScheme", this.factoryClassName), classNotFoundException);
            }
            return false;
        }
    }

    @Override
    public Object realize(ParameterProvider parameterProvider) {
        try {
            Class<?> clazz = this.getContextClassLoader().loadClass(this.factoryClassName.evaluate(parameterProvider).getString());
            String methodName = this.factoryMethodName.evaluate(parameterProvider).getString();
            Method compatibleMethod = null;
            Object[] methodParameters = this.parameters.size() == 0 ? null : new Object[this.parameters.size()];
            Method[] methods = clazz.getMethods();
            for (int i = 0; i < methods.length && compatibleMethod == null; ++i) {
                if (!methods[i].getName().equals(methodName) || methods[i].getParameterTypes().length != this.parameters.size() || !Modifier.isStatic(methods[i].getModifiers()) || methods[i].getReturnType() == null) continue;
                Class<?>[] methodParameterTypes = methods[i].getParameterTypes();
                boolean isCompatible = true;
                try {
                    int j = 0;
                    for (Parameter proposedParameter : this.parameters) {
                        Value valProposed = proposedParameter.evaluate(parameterProvider);
                        Class<?> clzParameter = methodParameterTypes[j];
                        if (valProposed.isNull()) {
                            methodParameters[j] = null;
                        } else {
                            Class<?> clzProposed = valProposed.getObject().getClass();
                            if (clzParameter.isAssignableFrom(clzProposed) || clzParameter.isPrimitive() && ReflectionHelper.isAssignablePrimitive(clzParameter, clzProposed)) {
                                methodParameters[j] = valProposed.getObject();
                            } else if (valProposed.getObject() instanceof ParameterizedBuilder && ((ReflectiveBuilder)valProposed.getObject()).realizesClassOf(clzParameter, parameterProvider)) {
                                methodParameters[j] = ((ParameterizedBuilder)valProposed.getObject()).realize(parameterProvider);
                            } else if (proposedParameter.isStronglyTyped()) {
                                clzProposed = this.getContextClassLoader().loadClass(proposedParameter.getType());
                                if (clzParameter.isAssignableFrom(clzProposed) || clzParameter.isPrimitive() && ReflectionHelper.isAssignablePrimitive(clzParameter, clzProposed)) {
                                    methodParameters[j] = valProposed.getValue(clzProposed);
                                } else {
                                    isCompatible = false;
                                }
                            } else {
                                methodParameters[j] = valProposed.getValue(clzParameter);
                            }
                        }
                        ++j;
                    }
                }
                catch (Exception exception) {
                    isCompatible = false;
                }
                if (!isCompatible) continue;
                compatibleMethod = methods[i];
            }
            if (compatibleMethod == null) {
                throw new NoSuchMethodException(String.format("Unable to find a compatible method for %s with the parameters %s", methodName, this.parameters));
            }
            return compatibleMethod.invoke(clazz, methodParameters);
        }
        catch (Exception exception) {
            throw Base.ensureRuntimeException((Throwable)exception);
        }
    }

    public void readExternal(DataInput in) throws IOException {
        this.factoryClassName = (Expression)ExternalizableHelper.readObject((DataInput)in, (ClassLoader)this.getClass().getClassLoader());
        this.factoryMethodName = (Expression)ExternalizableHelper.readObject((DataInput)in, (ClassLoader)this.getClass().getClassLoader());
        this.parameters = (ParameterProvider)ExternalizableHelper.readObject((DataInput)in, (ClassLoader)this.getClass().getClassLoader());
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.factoryClassName);
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.factoryMethodName);
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.parameters);
    }

    public void readExternal(PofReader reader) throws IOException {
        this.factoryClassName = (Expression)reader.readObject(1);
        this.factoryMethodName = (Expression)reader.readObject(2);
        this.parameters = (ParameterProvider)reader.readObject(3);
    }

    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeObject(1, (Object)this.factoryClassName);
        writer.writeObject(2, (Object)this.factoryMethodName);
        writer.writeObject(3, (Object)this.parameters);
    }
}

