/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.builders;

import com.oracle.coherence.common.builders.AbstractClassLoaderAwareParameterizedBuilder;
import com.oracle.coherence.common.builders.ParameterizedBuilder;
import com.oracle.coherence.common.util.ReflectionHelper;
import com.oracle.coherence.configuration.parameters.ParameterProvider;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VarArgsParameterizedBuilder<T>
extends AbstractClassLoaderAwareParameterizedBuilder<T>
implements ExternalizableLite,
PortableObject {
    private static final Logger logger = Logger.getLogger(VarArgsParameterizedBuilder.class.getName());
    private String className;
    private Object[] constructorParameters;

    public VarArgsParameterizedBuilder() {
    }

    public VarArgsParameterizedBuilder(Class<?> clazz, Object ... constructorParameters) {
        this.className = clazz.getName();
        this.constructorParameters = constructorParameters;
    }

    public VarArgsParameterizedBuilder(String className, Object ... constructorParameters) {
        this.className = className;
        this.constructorParameters = constructorParameters;
    }

    @Override
    public boolean realizesClassOf(Class<?> clazz, ParameterProvider parameterProvider) {
        try {
            Class<?> parameterizedClazz = Class.forName(this.className, false, this.getContextClassLoader());
            return clazz.isAssignableFrom(parameterizedClazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, String.format("Class %s not found while attempting to determine type information of a ReflectiveScheme", this.className), classNotFoundException);
            }
            return false;
        }
    }

    @Override
    public T realize(ParameterProvider parameterProvider) {
        try {
            Object[] parameters = new Object[this.constructorParameters.length];
            for (int i = 0; i < this.constructorParameters.length; ++i) {
                parameters[i] = this.constructorParameters[i] instanceof ParameterizedBuilder ? ((ParameterizedBuilder)this.constructorParameters[i]).realize(parameterProvider) : this.constructorParameters[i];
            }
            return (T)ReflectionHelper.createObject(this.className, parameters, this.getClass().getClassLoader());
        }
        catch (Exception exception) {
            throw Base.ensureRuntimeException((Throwable)exception);
        }
    }

    public void readExternal(DataInput in) throws IOException {
        this.className = ExternalizableHelper.readSafeUTF((DataInput)in);
        int parameterCount = ExternalizableHelper.readInt((DataInput)in);
        this.constructorParameters = new Object[parameterCount];
        for (int i = 0; i < parameterCount; ++i) {
            this.constructorParameters[i] = ExternalizableHelper.readObject((DataInput)in);
        }
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeSafeUTF((DataOutput)out, (String)this.className);
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.constructorParameters.length);
        for (int i = 0; i < this.constructorParameters.length; ++i) {
            ExternalizableHelper.writeObject((DataOutput)out, (Object)this.constructorParameters[i]);
        }
    }

    public void readExternal(PofReader reader) throws IOException {
        this.className = reader.readString(1);
        int parameterCount = reader.readInt(2);
        this.constructorParameters = new Object[parameterCount];
        for (int i = 0; i < parameterCount; ++i) {
            this.constructorParameters[i] = reader.readObject(3 + i);
        }
    }

    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeString(1, this.className);
        writer.writeInt(2, this.constructorParameters.length);
        for (int i = 0; i < this.constructorParameters.length; ++i) {
            writer.writeObject(3 + i, this.constructorParameters[i]);
        }
    }
}

