/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.cluster;

import com.oracle.coherence.common.cluster.ClusterMetaInfo;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class SimpleClusterMetaInfo
implements ClusterMetaInfo,
ExternalizableLite,
PortableObject {
    private String siteName;
    private String clusterName;

    public SimpleClusterMetaInfo() {
    }

    public SimpleClusterMetaInfo(String siteName, String clusterName) {
        this.siteName = siteName == null ? "" : siteName.trim();
        this.clusterName = clusterName == null ? "" : clusterName.trim();
    }

    @Override
    public String getUniqueName() {
        return this.siteName.isEmpty() ? this.getClusterName() : this.getSiteName() + "." + this.getClusterName();
    }

    @Override
    public String getSiteName() {
        return this.siteName.isEmpty() ? "<undefined>" : this.siteName;
    }

    @Override
    public String getClusterName() {
        return this.clusterName.isEmpty() ? "<undefined>" : this.clusterName;
    }

    public void readExternal(DataInput in) throws IOException {
        this.siteName = ExternalizableHelper.readSafeUTF((DataInput)in);
        this.clusterName = ExternalizableHelper.readSafeUTF((DataInput)in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeSafeUTF((DataOutput)out, (String)this.siteName);
        ExternalizableHelper.writeSafeUTF((DataOutput)out, (String)this.clusterName);
    }

    public void readExternal(PofReader reader) throws IOException {
        this.siteName = reader.readString(1);
        this.clusterName = reader.readString(2);
    }

    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeString(1, this.siteName);
        writer.writeString(2, this.clusterName);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clusterName == null ? 0 : this.clusterName.hashCode());
        result = 31 * result + (this.siteName == null ? 0 : this.siteName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleClusterMetaInfo other = (SimpleClusterMetaInfo)obj;
        if (this.clusterName == null ? other.clusterName != null : !this.clusterName.equals(other.clusterName)) {
            return false;
        }
        return !(this.siteName == null ? other.siteName != null : !this.siteName.equals(other.siteName));
    }

    public String toString() {
        return String.format("SimpleClusterInfo{siteName=%s, clusterName=%s}", this.siteName, this.clusterName);
    }
}

