/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.events.backingmap;

import com.oracle.coherence.common.events.backingmap.BackingMapEntryEvent;
import com.tangosol.io.Serializer;
import com.tangosol.net.BackingMapContext;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.ValueUpdater;
import java.util.Map;

public abstract class AbstractBackingMapEntryEvent
implements BackingMapEntryEvent {
    protected final BackingMapManagerContext backingMapManagerContext;
    private final String cacheName;
    private final EventEntry entry;

    public AbstractBackingMapEntryEvent(BackingMapManagerContext backingMapManagerContext, String cacheName, Map.Entry<?, ?> entry) {
        this.backingMapManagerContext = backingMapManagerContext;
        this.cacheName = cacheName;
        this.entry = entry instanceof EventEntry ? (EventEntry)entry : (entry instanceof BinaryEntry ? new EventEntry((BinaryEntry)entry) : new EventEntry(entry.getKey(), entry.getValue()));
    }

    public AbstractBackingMapEntryEvent(BackingMapManagerContext backingMapManagerContext, String cacheName, Object key, Object value) {
        this.backingMapManagerContext = backingMapManagerContext;
        this.cacheName = cacheName;
        this.entry = new EventEntry(key, value);
    }

    @Override
    public BackingMapManagerContext getContext() {
        return this.backingMapManagerContext;
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }

    @Override
    public BinaryEntry getEntry() {
        return this.entry;
    }

    public String toString() {
        return String.format("%s{cacheName=%s, entry=%s}", this.getClass().getName(), this.getCacheName(), this.getEntry());
    }

    protected class EventEntry
    implements Map.Entry,
    BinaryEntry {
        private Binary binaryKey;
        private Binary binaryValue;
        private Object deserializedKey;
        private Object deserializedValue;

        public EventEntry(BinaryEntry binaryEntry) {
            this.binaryKey = binaryEntry.getBinaryKey();
            this.binaryValue = binaryEntry.getBinaryValue();
            this.deserializedKey = Void.TYPE;
            this.deserializedValue = Void.TYPE;
        }

        public EventEntry(Object key, Object value) {
            if (key instanceof Binary) {
                this.binaryKey = (Binary)key;
                this.deserializedKey = Void.TYPE;
            } else {
                this.binaryKey = Binary.NO_BINARY;
                this.deserializedKey = key;
            }
            if (value instanceof Binary) {
                this.binaryValue = (Binary)value;
                this.deserializedValue = Void.TYPE;
            } else {
                this.binaryValue = Binary.NO_BINARY;
                this.deserializedValue = value;
            }
        }

        public boolean isReadOnly() {
            return true;
        }

        public Serializer getSerializer() {
            return this.getContext().getCacheService().getSerializer();
        }

        public ObservableMap getBackingMap() {
            return this.getBackingMapContext().getBackingMap();
        }

        public BackingMapManagerContext getContext() {
            return AbstractBackingMapEntryEvent.this.backingMapManagerContext;
        }

        public BackingMapContext getBackingMapContext() {
            return AbstractBackingMapEntryEvent.this.backingMapManagerContext.getBackingMapContext(AbstractBackingMapEntryEvent.this.getCacheName());
        }

        public void expire(long durationMS) {
        }

        public Object getKey() {
            if (this.deserializedKey == Void.TYPE) {
                this.deserializedKey = this.getContext().getKeyFromInternalConverter().convert((Object)this.binaryKey);
            }
            return this.deserializedKey;
        }

        public Binary getBinaryKey() {
            if (this.binaryKey == Binary.NO_BINARY) {
                this.binaryKey = (Binary)this.getContext().getKeyToInternalConverter().convert(this.deserializedKey);
            }
            return this.binaryKey;
        }

        public Object getValue() {
            if (this.deserializedValue == Void.TYPE) {
                this.deserializedValue = this.getContext().getValueFromInternalConverter().convert((Object)this.binaryValue);
            }
            return this.deserializedValue;
        }

        public Binary getBinaryValue() {
            if (this.binaryValue == Binary.NO_BINARY) {
                this.binaryValue = (Binary)this.getContext().getValueToInternalConverter().convert(this.deserializedValue);
            }
            return this.binaryValue;
        }

        public Object extract(ValueExtractor extractor) {
            return InvocableMapHelper.extractFromEntry((ValueExtractor)extractor, (Map.Entry)AbstractBackingMapEntryEvent.this.entry);
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException("Can not call setValue(Object) an an EventEntry as they are immutable");
        }

        public void updateBinaryValue(Binary binary) {
            throw new UnsupportedOperationException("Can not call updateBinaryValue(Binary) an an EventEntry as they are immutable");
        }

        public boolean isPresent() {
            return true;
        }

        public void remove(boolean synthetic) {
            throw new UnsupportedOperationException("Can not call remove(boolean) an an EventEntry as they are immutable");
        }

        public void setValue(Object value, boolean synthetic) {
            throw new UnsupportedOperationException("Can not call setValue(Object, boolean) an an EventEntry as they are immutable");
        }

        public void update(ValueUpdater valueUpdater, Object object) {
            throw new UnsupportedOperationException("Can not call update(ValueUpdater, Object) an an EventEntry as they are immutable");
        }

        public Binary getOriginalBinaryValue() {
            return null;
        }

        public Object getOriginalValue() {
            return null;
        }

        public String toString() {
            return String.format("%s{key=%s, value=%s}", this.getClass().getName(), this.getKey(), this.getValue());
        }
    }
}

