/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.events.dispatching;

import com.oracle.coherence.common.events.Event;
import com.oracle.coherence.common.events.dispatching.EventDispatcher;
import com.oracle.coherence.common.events.processing.EventProcessor;
import com.oracle.coherence.common.events.processing.LifecycleAwareEventProcessor;
import com.oracle.coherence.environment.Environment;
import com.tangosol.util.Filter;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SimpleEventDispatcher
implements EventDispatcher {
    private static Logger logger = Logger.getLogger(SimpleEventDispatcher.class.getName());
    private Environment environment;
    private ConcurrentHashMap<Filter, CopyOnWriteArraySet<EventProcessor<?>>> eventProcessors;

    public SimpleEventDispatcher(Environment environment) {
        this.environment = environment;
        this.eventProcessors = new ConcurrentHashMap();
    }

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public <E extends Event> void dispatchEvent(E event, EventProcessor<E> eventProcessor) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "[Commenced] Processing {0} with {1}", new Object[]{event, eventProcessor});
        }
        eventProcessor.process(this, event);
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "[Completed] Processing {0} with {1}", new Object[]{event, eventProcessor});
        }
        this.dispatchEvent(event);
    }

    @Override
    public <E extends Event> void dispatchEventLater(final E event) {
        this.getEnvironment().getResource(ExecutorService.class).execute(new Runnable(){

            @Override
            public void run() {
                SimpleEventDispatcher.this.dispatchEvent(event);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E extends Event> boolean registerEventProcessor(Filter filter, EventProcessor<E> eventProcessor) {
        ConcurrentHashMap<Filter, CopyOnWriteArraySet<EventProcessor<?>>> concurrentHashMap = this.eventProcessors;
        synchronized (concurrentHashMap) {
            boolean isAlreadyRegistered;
            Set eventProcessorSet = this.eventProcessors.putIfAbsent(filter, new CopyOnWriteArraySet());
            if (eventProcessorSet == null) {
                eventProcessorSet = this.eventProcessors.get(filter);
            }
            if (!(isAlreadyRegistered = eventProcessorSet.contains(eventProcessor))) {
                if (eventProcessor instanceof LifecycleAwareEventProcessor) {
                    ((LifecycleAwareEventProcessor)((Object)eventProcessor)).onBeforeRegistered(this);
                }
                eventProcessorSet.add(eventProcessor);
                if (eventProcessor instanceof LifecycleAwareEventProcessor) {
                    ((LifecycleAwareEventProcessor)((Object)eventProcessor)).onAfterRegistered(this);
                }
            }
            return !isAlreadyRegistered;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E extends Event> void unregisterEventProcessor(Filter filter, EventProcessor<E> eventProcessor) {
        ConcurrentHashMap<Filter, CopyOnWriteArraySet<EventProcessor<?>>> concurrentHashMap = this.eventProcessors;
        synchronized (concurrentHashMap) {
            Set eventProcessorSet = this.eventProcessors.get(filter);
            if (eventProcessorSet != null) {
                if (eventProcessorSet.remove(eventProcessor) && eventProcessor instanceof LifecycleAwareEventProcessor) {
                    ((LifecycleAwareEventProcessor)((Object)eventProcessor)).onAfterUnregistered(this);
                }
                if (eventProcessorSet.isEmpty()) {
                    this.eventProcessors.remove(filter);
                }
            }
        }
    }

    @Override
    public <E extends Event> void dispatchEvent(E event) {
        for (Filter filter : this.eventProcessors.keySet()) {
            if (!filter.evaluate(event)) continue;
            for (EventProcessor<?> eventProcessor : this.eventProcessors.get(filter)) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "[Commenced] Processing {0} with {1}", new Object[]{event, eventProcessor});
                }
                eventProcessor.process(this, event);
                if (!logger.isLoggable(Level.FINEST)) continue;
                logger.log(Level.FINEST, "[Completed] Processing {0} with {1}", new Object[]{event, eventProcessor});
            }
        }
    }
}

