/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.events.dispatching.listeners;

import com.oracle.coherence.common.events.dispatching.EventDispatcher;
import com.oracle.coherence.common.events.partition.AbstractPartitionEvent;
import com.oracle.coherence.common.events.partition.PartitionArrivingEvent;
import com.oracle.coherence.common.events.partition.PartitionDepartingEvent;
import com.oracle.coherence.common.events.partition.PartitionLostEvent;
import com.oracle.coherence.common.events.partition.PartitionRecoveringEvent;
import com.oracle.coherence.common.events.processing.EventProcessor;
import com.oracle.coherence.common.events.processing.EventProcessorFactory;
import com.oracle.coherence.environment.Environment;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.PartitionedService;
import com.tangosol.net.partition.PartitionEvent;
import com.tangosol.net.partition.PartitionListener;

public abstract class AbstractDelegatingPartitionListener
implements PartitionListener,
EventProcessorFactory<com.oracle.coherence.common.events.partition.PartitionEvent> {
    protected EventDispatcher getEventDispatcher(PartitionedService partitionedService) {
        ConfigurableCacheFactory ccf = CacheFactory.getCacheFactoryBuilder().getConfigurableCacheFactory(partitionedService.getContextClassLoader());
        if (ccf instanceof Environment) {
            Environment environment = (Environment)ccf;
            EventDispatcher eventDispatcher = environment.getResource(EventDispatcher.class);
            if (eventDispatcher == null) {
                throw new RuntimeException("Failed to locate the EventDispatcher resource.  Your application appears to be incorrectly configured or your Environment does not support EventDispatching");
            }
            return eventDispatcher;
        }
        throw new RuntimeException("Can not locate the EventDispatcher resource as the ConfigurableCacheFactory does not support Environments. At a minimum you should configure your application to use the ExtensibleEnvironment.");
    }

    public void onPartitionEvent(PartitionEvent partitionEvent) {
        AbstractPartitionEvent event;
        switch (partitionEvent.getId()) {
            case 1: {
                event = new PartitionLostEvent(partitionEvent);
                break;
            }
            case 5: 
            case 6: {
                if (partitionEvent.getFromMember() == null) {
                    event = new PartitionRecoveringEvent(partitionEvent);
                    break;
                }
                event = new PartitionArrivingEvent(partitionEvent);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                event = new PartitionDepartingEvent(partitionEvent);
                break;
            }
            default: {
                event = null;
            }
        }
        if (event != null) {
            EventProcessor eventProcessor = this.getEventProcessor(event);
            this.getEventDispatcher(event.getService()).dispatchEvent(event, eventProcessor);
        }
    }
}

