/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.events.dispatching.listeners;

import com.oracle.coherence.common.builders.ParameterizedBuilder;
import com.oracle.coherence.common.events.EntryEvent;
import com.oracle.coherence.common.events.Event;
import com.oracle.coherence.common.events.backingmap.AbstractBackingMapEntryEvent;
import com.oracle.coherence.common.events.backingmap.BackingMapEntryArrivedEvent;
import com.oracle.coherence.common.events.backingmap.BackingMapEntryDepartedEvent;
import com.oracle.coherence.common.events.backingmap.BackingMapEntryEvictedEvent;
import com.oracle.coherence.common.events.backingmap.BackingMapEntryInsertedEvent;
import com.oracle.coherence.common.events.backingmap.BackingMapEntryRemovedEvent;
import com.oracle.coherence.common.events.backingmap.BackingMapEntryStoredEvent;
import com.oracle.coherence.common.events.backingmap.BackingMapEntryUpdatedEvent;
import com.oracle.coherence.common.events.dispatching.EventDispatcher;
import com.oracle.coherence.common.events.processing.EventProcessor;
import com.oracle.coherence.common.events.processing.EventProcessorFactory;
import com.oracle.coherence.common.events.processing.annotations.EventProcessorFor;
import com.oracle.coherence.common.events.processing.annotations.LiveObject;
import com.oracle.coherence.common.events.processing.annotations.SupportsEventProcessing;
import com.oracle.coherence.configuration.caching.CacheMapping;
import com.oracle.coherence.configuration.caching.CacheMappingRegistry;
import com.oracle.coherence.configuration.parameters.SystemPropertyParameterProvider;
import com.oracle.coherence.environment.Environment;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.cache.CacheEvent;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DelegatingBackingMapListener
implements MapListener {
    private static final Logger logger = Logger.getLogger(DelegatingBackingMapListener.class.getName());
    private BackingMapManagerContext m_ctxBackingMapManager;
    private String m_sCacheName;
    private volatile EventProcessor<Event> m_eventProcessor;
    private volatile EventDispatcher m_eventDispatcher;
    private Environment m_environment;
    private ConcurrentHashMap<Class<?>, LinkedHashMap<Class<? extends Event>, EventProcessor<? extends Event>>> m_mapEventProcessingMethodsByClass;

    public DelegatingBackingMapListener(BackingMapManagerContext backingMapManagerContext, String cacheName) {
        this(backingMapManagerContext, cacheName, (Environment)CacheFactory.getConfigurableCacheFactory());
    }

    public DelegatingBackingMapListener(BackingMapManagerContext backingMapManagerContext, String cacheName, Environment environment) {
        this.m_ctxBackingMapManager = backingMapManagerContext;
        this.m_sCacheName = cacheName;
        this.m_environment = environment;
        this.m_mapEventProcessingMethodsByClass = new ConcurrentHashMap();
        CacheMapping cacheMapping = environment.getResource(CacheMappingRegistry.class).findCacheMapping(cacheName);
        ParameterizedBuilder builder = cacheMapping.getEnrichment(ParameterizedBuilder.class, "event-processor");
        if (builder != null) {
            this.m_eventProcessor = (EventProcessor)builder.realize(SystemPropertyParameterProvider.INSTANCE);
        }
    }

    public String getCacheName() {
        return this.m_sCacheName;
    }

    public BackingMapManagerContext getContext() {
        return this.m_ctxBackingMapManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventDispatcher getEventDispatcher() {
        if (this.m_eventDispatcher == null) {
            DelegatingBackingMapListener delegatingBackingMapListener = this;
            synchronized (delegatingBackingMapListener) {
                if (this.m_eventDispatcher == null) {
                    this.m_eventDispatcher = this.m_environment.getResource(EventDispatcher.class);
                    if (this.m_eventDispatcher == null) {
                        throw new RuntimeException("Failed to locate the EventDispatcher resource.  Your application appears to be incorrectly configured or your Environment does not support EventDispatching");
                    }
                    return this.m_eventDispatcher;
                }
                return this.m_eventDispatcher;
            }
        }
        return this.m_eventDispatcher;
    }

    protected boolean isDecorationRemoved(MapEvent evt, int nDecorationId) {
        Binary binOldValue = (Binary)evt.getOldValue();
        Binary binNewValue = (Binary)evt.getNewValue();
        BackingMapManagerContext ctx = this.getContext();
        return binOldValue != null && ctx.isInternalValueDecorated((Object)binOldValue, nDecorationId) && !ctx.isInternalValueDecorated((Object)binNewValue, nDecorationId);
    }

    public void entryInserted(MapEvent mapEvent) {
        AbstractBackingMapEntryEvent event = this.getContext().isKeyOwned(mapEvent.getKey()) ? (this.isDecorationRemoved(mapEvent, 2) ? new BackingMapEntryStoredEvent(this.getContext(), this.getCacheName(), mapEvent.getKey(), mapEvent.getNewValue()) : new BackingMapEntryInsertedEvent(this.getContext(), this.getCacheName(), mapEvent.getKey(), mapEvent.getNewValue())) : new BackingMapEntryArrivedEvent(this.getContext(), this.getCacheName(), mapEvent.getKey(), mapEvent.getNewValue());
        this.scheduleProcessor(event);
    }

    public void entryUpdated(MapEvent mapEvent) {
        BackingMapEntryUpdatedEvent event = new BackingMapEntryUpdatedEvent(this.getContext(), this.getCacheName(), mapEvent.getKey(), mapEvent.getOldValue(), mapEvent.getNewValue());
        this.scheduleProcessor(event);
    }

    public void entryDeleted(MapEvent mapEvent) {
        BackingMapEntryRemovedEvent event = this.m_ctxBackingMapManager.isKeyOwned(mapEvent.getKey()) ? (mapEvent instanceof CacheEvent && ((CacheEvent)mapEvent).isSynthetic() ? new BackingMapEntryEvictedEvent(this.getContext(), this.getCacheName(), mapEvent.getKey(), mapEvent.getOldValue()) : new BackingMapEntryRemovedEvent(this.getContext(), this.getCacheName(), mapEvent.getKey(), mapEvent.getOldValue())) : new BackingMapEntryDepartedEvent(this.getContext(), this.getCacheName(), mapEvent.getKey(), mapEvent.getOldValue());
        this.scheduleProcessor(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkedHashMap<Class<? extends Event>, EventProcessor<? extends Event>> getEventProcessingMethods(Class<?> clzEventProcessing) {
        LinkedHashMap<Class<Event>, EventProcessor<Event>> mapEventProcessingMethods = this.m_mapEventProcessingMethodsByClass.get(clzEventProcessing);
        if (mapEventProcessingMethods == null) {
            Class<?> clazz = clzEventProcessing;
            synchronized (clazz) {
                mapEventProcessingMethods = this.m_mapEventProcessingMethodsByClass.get(clzEventProcessing);
                if (mapEventProcessingMethods == null) {
                    Class<?> clzAnnotated;
                    for (clzAnnotated = clzEventProcessing; clzAnnotated != null && clzAnnotated.getAnnotation(SupportsEventProcessing.class) == null && clzAnnotated.getAnnotation(LiveObject.class) == null; clzAnnotated = clzAnnotated.getSuperclass()) {
                    }
                    mapEventProcessingMethods = new LinkedHashMap();
                    if (clzAnnotated != null) {
                        for (Class<?> clz = clzEventProcessing; clz != Object.class && clz != null; clz = clz.getSuperclass()) {
                            for (Method method : clz.getDeclaredMethods()) {
                                EventProcessorFor eventProcessorFor;
                                if (method.getParameterTypes().length != 2 || (eventProcessorFor = method.getAnnotation(EventProcessorFor.class)) == null) continue;
                                for (Class<? extends Event> clzEvent : eventProcessorFor.events()) {
                                    if (mapEventProcessingMethods.containsKey(clzEvent)) continue;
                                    mapEventProcessingMethods.put(clzEvent, new MethodBasedEventProcessor(method));
                                }
                            }
                        }
                    }
                    this.m_mapEventProcessingMethodsByClass.put(clzEventProcessing, mapEventProcessingMethods);
                }
            }
        }
        return mapEventProcessingMethods;
    }

    private void scheduleProcessor(Event event) {
        if (event instanceof EntryEvent) {
            EventProcessor<Event> processor;
            EntryEvent entryEvent = (EntryEvent)event;
            if (this.m_eventProcessor == null) {
                Object oValue = entryEvent.getEntry().getValue();
                if (oValue == null) {
                    processor = null;
                } else if (oValue instanceof EventProcessor) {
                    processor = (EventProcessor<EntryEvent>)oValue;
                } else if (oValue instanceof EventProcessorFactory) {
                    processor = ((EventProcessorFactory)oValue).getEventProcessor(entryEvent);
                } else {
                    Class<?> clzValue = oValue.getClass();
                    LinkedHashMap<Class<? extends Event>, EventProcessor<? extends Event>> mapEventProcessingMethods = this.getEventProcessingMethods(clzValue);
                    if (mapEventProcessingMethods.isEmpty()) {
                        processor = null;
                    } else {
                        processor = null;
                        for (Class<? extends Event> clzEvent : mapEventProcessingMethods.keySet()) {
                            if (!clzEvent.isInstance(entryEvent)) continue;
                            processor = mapEventProcessingMethods.get(clzEvent);
                            break;
                        }
                    }
                }
            } else {
                processor = this.m_eventProcessor;
            }
            if (processor == null) {
                this.getEventDispatcher().dispatchEvent(entryEvent);
            } else {
                this.getEventDispatcher().dispatchEvent(entryEvent, processor);
            }
        }
    }

    private static class MethodBasedEventProcessor
    implements EventProcessor<EntryEvent<?>> {
        private Method method;

        public MethodBasedEventProcessor(Method method) {
            this.method = method;
        }

        @Override
        public void process(EventDispatcher eventDispatcher, EntryEvent<?> event) {
            try {
                this.method.invoke(event.getEntry().getValue(), eventDispatcher, event);
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, "Exception in process method ", exception);
                throw Base.ensureRuntimeException((Throwable)exception);
            }
        }
    }
}

