/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.finitestatemachines;

import com.oracle.coherence.common.finitestatemachines.Event;
import com.oracle.coherence.common.finitestatemachines.ExecutionContext;
import com.oracle.coherence.common.finitestatemachines.Instruction;
import com.oracle.coherence.common.finitestatemachines.Model;
import com.oracle.coherence.common.finitestatemachines.RollbackTransitionException;
import com.oracle.coherence.common.finitestatemachines.SimpleModel;
import com.oracle.coherence.common.finitestatemachines.StateEntryAction;
import com.oracle.coherence.common.finitestatemachines.StateExitAction;
import com.oracle.coherence.common.finitestatemachines.TransitionAction;
import com.oracle.coherence.common.finitestatemachines.annotations.OnEnterState;
import com.oracle.coherence.common.finitestatemachines.annotations.OnExitState;
import com.oracle.coherence.common.finitestatemachines.annotations.OnTransition;
import com.oracle.coherence.common.finitestatemachines.annotations.Transition;
import com.oracle.coherence.common.finitestatemachines.annotations.Transitions;
import com.oracle.coherence.common.util.ReflectionHelper;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.EnumMap;
import java.util.Map;

public class AnnotationDrivenModel<S extends Enum<S>>
implements Model<S> {
    private SimpleModel<S> m_model;

    public AnnotationDrivenModel(Class<S> clzState, Object instance) {
        TransitionActionMethod action;
        S stateFrom;
        if (instance == null) {
            throw new IllegalArgumentException(String.format("Can't create an %s from a null instance", this.getClass().getName()));
        }
        Class<?> clzInstance = instance.getClass();
        this.m_model = new SimpleModel<S>(clzState);
        EnumMap mapTransitionNames = new EnumMap(clzState);
        EnumMap mapTransitionActions = new EnumMap(clzState);
        for (Enum state : this.m_model.getStates()) {
            mapTransitionNames.put(state, new EnumMap(clzState));
            mapTransitionActions.put(state, new EnumMap(clzState));
        }
        for (Class<?> clz = clzInstance; clz != null; clz = clz.getSuperclass()) {
            Transitions annTransitions = clz.getAnnotation(Transitions.class);
            if (annTransitions == null) continue;
            for (Transition annTransition : annTransitions.value()) {
                String sProvidedTransitionName = annTransition.name();
                sProvidedTransitionName = sProvidedTransitionName == null || sProvidedTransitionName.trim().isEmpty() ? null : sProvidedTransitionName;
                String sStateToName = annTransition.toState();
                S stateTo = this.m_model.getState(sStateToName);
                if (stateTo == null) {
                    throw new IllegalArgumentException(String.format("The %s defined on %s declares a to state %s that is not defined by %s.", annTransition, clzInstance, sStateToName, clzState));
                }
                for (String sStateFromName : annTransition.fromStates()) {
                    stateFrom = this.m_model.getState(sStateFromName);
                    if (stateFrom == null) {
                        throw new IllegalArgumentException(String.format("The %s defined on %s declares a from state %s that is not defined by %s.", annTransition, clzInstance, sStateFromName, clzState));
                    }
                    String sTransitionName = sProvidedTransitionName == null ? String.format("%s to %s", ((Enum)stateFrom).name(), ((Enum)stateTo).name()) : sProvidedTransitionName;
                    ((EnumMap)mapTransitionNames.get(stateFrom)).put(stateTo, sTransitionName);
                }
            }
        }
        for (Method method : clzInstance.getMethods()) {
            OnTransition annOnTransition;
            OnExitState annOnExitState;
            OnEnterState annOnEnterState = method.getAnnotation(OnEnterState.class);
            if (annOnEnterState != null) {
                S state = this.m_model.getState(annOnEnterState.value());
                if (state == null) {
                    throw new IllegalArgumentException(String.format("The %s annotation on method %s defined in %s declares the state %s that is not defined in %s.", annOnEnterState, method, clzInstance, annOnEnterState.value(), clzState));
                }
                if (ReflectionHelper.isCompatibleMethod(method, 1, Instruction.class, new Type[]{clzState, clzState, Event.class, ExecutionContext.class})) {
                    this.m_model.addStateEntryAction(state, new StateEntryActionMethod(instance, method));
                } else {
                    throw new IllegalArgumentException(String.format("The method %s defined in class %s annotated with %s is not compatible with the required method signature 'Instruction method(State, State, Context<State>);'.", method, clzInstance, annOnEnterState));
                }
            }
            if ((annOnExitState = method.getAnnotation(OnExitState.class)) != null) {
                S state = this.m_model.getState(annOnExitState.value());
                if (state == null) {
                    throw new IllegalArgumentException(String.format("The %s annotation on method %s defined in %s declares the state %s that is not defined in %s.", annOnExitState, method, clzInstance, annOnExitState.value(), clzState));
                }
                if (ReflectionHelper.isCompatibleMethod(method, 1, Void.TYPE, new Type[]{clzState, Event.class, ExecutionContext.class})) {
                    this.m_model.addStateExitAction(state, new StateExitActionMethod(instance, method));
                } else {
                    throw new IllegalArgumentException(String.format("The method %s defined in class %s annotated with %s is not compatible with the required method signature 'void method(State, Context<State>);'.", method, clzInstance, annOnExitState));
                }
            }
            if ((annOnTransition = method.getAnnotation(OnTransition.class)) == null) continue;
            if (ReflectionHelper.isCompatibleMethod(method, 1, Void.TYPE, new Type[]{String.class, clzState, clzState, Event.class, ExecutionContext.class})) {
                action = new TransitionActionMethod(instance, method);
                for (String sStateFromName : annOnTransition.fromStates()) {
                    stateFrom = this.m_model.getState(sStateFromName);
                    if (stateFrom == null) {
                        throw new IllegalArgumentException(String.format("The %s defined on method %s in %s declares a from state %s that is not defined by %s.", annOnTransition, method, clzInstance, sStateFromName, clzState));
                    }
                    for (String sStateToName : annOnTransition.toStates()) {
                        S stateTo = this.m_model.getState(sStateToName);
                        if (stateTo == null) {
                            throw new IllegalArgumentException(String.format("The %s defined on method %s in %s declares a from state %s that is not defined by %s.", annOnTransition, method, clzInstance, sStateToName, clzState));
                        }
                        if (!((EnumMap)mapTransitionNames.get(stateFrom)).containsKey(stateTo)) {
                            throw new IllegalArgumentException(String.format("The %s defined on method %s in %s specifies a transition from %s to %s that is not defined by the Finite State Machine.", annOnTransition, method, clzInstance, stateFrom, stateTo));
                        }
                        ((EnumMap)mapTransitionActions.get(stateFrom)).put(stateTo, action);
                    }
                }
                continue;
            }
            throw new IllegalArgumentException(String.format("The method %s defined in class %s annotated with %s is not compatible with the required method signature 'void method(String, State, State, Event<State>, Context<State>);'.", method, clzInstance, annOnTransition));
        }
        for (Enum stateFrom2 : this.m_model.getStates()) {
            for (Enum stateTo : mapTransitionNames.keySet()) {
                String sTransitionName = (String)((EnumMap)mapTransitionNames.get(stateFrom2)).get(stateTo);
                if (sTransitionName == null) continue;
                action = (TransitionActionMethod)((EnumMap)mapTransitionActions.get(stateFrom2)).get(stateTo);
                this.m_model.addTransition(new com.oracle.coherence.common.finitestatemachines.Transition<Enum>(sTransitionName, stateFrom2, stateTo, action));
            }
        }
    }

    @Override
    public Class<S> getStateClass() {
        return this.m_model.getStateClass();
    }

    @Override
    public Map<S, StateEntryAction<S>> getStateEntryActions() {
        return this.m_model.getStateEntryActions();
    }

    @Override
    public Map<S, StateExitAction<S>> getStateExitActions() {
        return this.m_model.getStateExitActions();
    }

    @Override
    public S[] getStates() {
        return this.m_model.getStates();
    }

    @Override
    public Iterable<com.oracle.coherence.common.finitestatemachines.Transition<S>> getTransitions() {
        return this.m_model.getTransitions();
    }

    private static class TransitionActionMethod<S extends Enum<S>>
    implements TransitionAction<S> {
        private Object m_instance;
        private Method m_method;

        public TransitionActionMethod(Object instance, Method method) {
            this.m_instance = instance;
            this.m_method = method;
        }

        @Override
        public void onTransition(String sTransitionName, S stateFrom, S stateTo, Event<S> event, ExecutionContext context) throws RollbackTransitionException {
            try {
                this.m_method.invoke(this.m_instance, sTransitionName, stateFrom, stateTo, event, context);
            }
            catch (Exception e) {
                throw new RollbackTransitionException((Enum<?>)stateFrom, (Enum<?>)stateTo, e);
            }
        }
    }

    private static class StateExitActionMethod<S extends Enum<S>>
    implements StateExitAction<S> {
        private Object m_instance;
        private Method m_method;

        public StateExitActionMethod(Object instance, Method method) {
            this.m_instance = instance;
            this.m_method = method;
        }

        @Override
        public void onExitState(S state, Event<S> event, ExecutionContext context) {
            try {
                this.m_method.invoke(this.m_instance, state, event, context);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class StateEntryActionMethod<S extends Enum<S>>
    implements StateEntryAction<S> {
        private Object m_instance;
        private Method m_method;

        public StateEntryActionMethod(Object instance, Method method) {
            this.m_instance = instance;
            this.m_method = method;
        }

        @Override
        public Instruction onEnterState(S previousState, S newState, Event<S> event, ExecutionContext context) {
            try {
                return (Instruction)this.m_method.invoke(this.m_instance, previousState, newState, event, context);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

