/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.finitestatemachines;

import com.oracle.coherence.common.finitestatemachines.Event;
import com.oracle.coherence.common.finitestatemachines.ExecutionContext;
import com.oracle.coherence.common.finitestatemachines.FiniteStateMachine;
import com.oracle.coherence.common.finitestatemachines.Instruction;
import com.oracle.coherence.common.finitestatemachines.LifecycleAwareEvent;
import com.oracle.coherence.common.finitestatemachines.Model;
import com.oracle.coherence.common.finitestatemachines.RollbackTransitionException;
import com.oracle.coherence.common.finitestatemachines.StateEntryAction;
import com.oracle.coherence.common.finitestatemachines.StateExitAction;
import com.oracle.coherence.common.finitestatemachines.Transition;
import com.oracle.coherence.common.finitestatemachines.TransitionAction;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.EnumMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NonBlockingFiniteStateMachine<S extends Enum<S>>
implements FiniteStateMachine<S>,
ExecutionContext {
    private static final Logger LOGGER = Logger.getLogger(NonBlockingFiniteStateMachine.class.getName());
    private String name;
    private volatile S state;
    private final S initialState;
    private EnumMap<S, EnumMap<S, Transition<S>>> transitions;
    private EnumMap<S, StateEntryAction<S>> stateEntryActions;
    private EnumMap<S, StateExitAction<S>> stateExitActions;
    private AtomicBoolean isStarted;
    private AtomicLong transitionCount;
    private AtomicBoolean isAcceptingEvents;
    private AtomicBoolean allowTransitions;
    private AtomicInteger pendingEventCount;
    private ScheduledExecutorService executorService;
    private boolean ignoreRuntimeExceptions;

    public NonBlockingFiniteStateMachine(String name, Model<S> model, S initialState, ScheduledExecutorService executorService, boolean ignoreRuntimeExceptions) {
        this(name, model, initialState, executorService, ignoreRuntimeExceptions, true);
    }

    public NonBlockingFiniteStateMachine(String name, Model<S> model, S initialState, ScheduledExecutorService executorService, boolean ignoreRuntimeExceptions, boolean autostart) {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(this.getClass().getName(), "Constructor", new Object[]{name, model, initialState, executorService, ignoreRuntimeExceptions});
        }
        this.name = name;
        this.allowTransitions = new AtomicBoolean(true);
        this.executorService = executorService;
        this.ignoreRuntimeExceptions = ignoreRuntimeExceptions;
        this.transitionCount = new AtomicLong(0L);
        this.initialState = initialState;
        Enum[] states = model.getStates();
        this.transitions = new EnumMap(model.getStateClass());
        for (Enum stateFrom : states) {
            this.transitions.put(stateFrom, new EnumMap(model.getStateClass()));
        }
        for (Transition<Enum> transition : model.getTransitions()) {
            for (Enum fromStates : states) {
                if (!transition.isStartingState(fromStates)) continue;
                this.transitions.get(fromStates).put(transition.getEndingState(), transition);
            }
        }
        this.stateEntryActions = new EnumMap(model.getStateClass());
        this.stateExitActions = new EnumMap(model.getStateClass());
        for (Enum state : states) {
            this.stateEntryActions.put(state, model.getStateEntryActions().get(state));
            this.stateExitActions.put(state, model.getStateExitActions().get(state));
        }
        this.state = null;
        if (autostart) {
            this.isStarted = new AtomicBoolean(true);
            this.isAcceptingEvents = new AtomicBoolean(true);
            this.pendingEventCount = new AtomicInteger(1);
            this.processEvent(new Instruction.TransitionTo<S>(initialState));
        } else {
            this.isStarted = new AtomicBoolean(false);
            this.isAcceptingEvents = new AtomicBoolean(false);
            this.pendingEventCount = new AtomicInteger(0);
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(this.getClass().getName(), "Constructor");
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public S getState() {
        return this.state;
    }

    @Override
    public long getTransitionCount() {
        return this.transitionCount.get();
    }

    @Override
    public boolean start() {
        boolean wasStarted;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(this.getClass().getName(), String.format("[%s]: start", this.getName()));
        }
        if (!this.allowTransitions.get()) {
            throw new IllegalStateException("The FiniteStateMachine cannot be started because it was stopped");
        }
        if (this.isStarted.compareAndSet(false, true)) {
            this.isAcceptingEvents.set(true);
            this.process(new Instruction.TransitionTo<S>(this.initialState));
            wasStarted = true;
        } else {
            wasStarted = false;
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(this.getClass().getName(), String.format("[%s]: start", this.getName()));
        }
        return wasStarted;
    }

    @Override
    public boolean stop() {
        boolean wasStopped;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(this.getClass().getName(), String.format("[%s]: stop", this.getName()));
        }
        if (this.isAcceptingEvents.compareAndSet(true, false)) {
            this.allowTransitions.set(false);
            wasStopped = true;
        } else {
            wasStopped = false;
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(this.getClass().getName(), String.format("[%s]: stop", this.getName()));
        }
        return wasStopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean quiesceThenStop() {
        boolean wasStopped;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(this.getClass().getName(), String.format("[%s]: quiesceThenStop", this.getName()));
        }
        if (this.isAcceptingEvents.compareAndSet(true, false)) {
            NonBlockingFiniteStateMachine nonBlockingFiniteStateMachine = this;
            synchronized (nonBlockingFiniteStateMachine) {
                while (this.pendingEventCount.get() > 0) {
                    try {
                        this.wait(500L);
                    }
                    catch (InterruptedException e) {
                        if (!LOGGER.isLoggable(Level.FINER)) break;
                        LOGGER.finer(String.format("[%s]: Thread interrupted while quiescing.  Will stop immediately.", this.name));
                        break;
                    }
                }
            }
            this.allowTransitions.set(false);
            wasStopped = this.pendingEventCount.get() == 0;
        } else {
            wasStopped = false;
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(this.getClass().getName(), String.format("[%s]: quiesceThenStop", this.getName()));
        }
        return wasStopped;
    }

    @Override
    public void process(Event<S> event) {
        this.processLater(event, 0L, TimeUnit.SECONDS);
    }

    public void processLater(Event<S> event) {
        this.processLater(event, 0L, TimeUnit.SECONDS);
    }

    public void processLater(Event<S> event, long duration, TimeUnit timeUnit) {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(this.getClass().getName(), String.format("[%s]: processLater", this.getName()), new Object[]{event, duration, timeUnit});
        }
        if (this.isAcceptingEvents.get()) {
            final Event<S> preparedEvent = this.prepareEvent(event);
            if (preparedEvent == null) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer(String.format("[%s]: Ignoring event %s as it vetoed being prepared", this.name, event));
                }
            } else {
                this.executorService.schedule(new Runnable(){

                    @Override
                    public void run() {
                        NonBlockingFiniteStateMachine.this.processEvent(preparedEvent);
                    }
                }, duration, timeUnit);
            }
        } else if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(String.format("[%s]: Ignoring request to process the event %s in %d %s as the machine is no longer accepting new transitions", new Object[]{this.name, event, duration, timeUnit}));
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(this.getClass().getName(), String.format("[%s]: processLater", this.getName()));
        }
    }

    private Event<S> prepareEvent(Event<S> event) {
        LifecycleAwareEvent prepared = null;
        if (this.isAcceptingEvents.get()) {
            LifecycleAwareEvent lifecycleAwareEvent;
            prepared = event instanceof LifecycleAwareEvent ? ((lifecycleAwareEvent = (LifecycleAwareEvent)event).onAccept(this) ? lifecycleAwareEvent : null) : event;
        }
        if (prepared != null) {
            this.pendingEventCount.incrementAndGet();
        }
        return prepared;
    }

    @Override
    public boolean hasPendingEvents() {
        return this.allowTransitions.get() && this.pendingEventCount.get() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEvent(Event<S> event) {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering(this.getClass().getName(), String.format("[%s]: processEvent", this.getName()), new Object[]{event});
        }
        NonBlockingFiniteStateMachine nonBlockingFiniteStateMachine = this;
        synchronized (nonBlockingFiniteStateMachine) {
            while (event != null && this.allowTransitions.get()) {
                Instruction instruction;
                LifecycleAwareEvent lifecycleAwareEvent;
                S stateDesired;
                block54: {
                    boolean isInitialTransition;
                    S stateCurrent;
                    block53: {
                        StringWriter writerString;
                        stateCurrent = this.getState();
                        stateDesired = event.getDesiredState(stateCurrent, this);
                        if (event instanceof LifecycleAwareEvent) {
                            LifecycleAwareEvent lifecycleAwareEvent2 = (LifecycleAwareEvent)event;
                            lifecycleAwareEvent2.onProcessing(stateCurrent, this);
                        }
                        isInitialTransition = stateCurrent == null;
                        this.pendingEventCount.decrementAndGet();
                        if (stateDesired == null) {
                            if (LOGGER.isLoggable(Level.FINER)) {
                                LOGGER.finer(String.format("[%s]: Ignoring event %s as it produced a null desired state.", this.name, event));
                            }
                            if (event instanceof LifecycleAwareEvent) {
                                LifecycleAwareEvent lifecycleAwareEvent3 = (LifecycleAwareEvent)event;
                                lifecycleAwareEvent3.onFailure(stateCurrent, this, null);
                            }
                            event = null;
                            continue;
                        }
                        Transition<S> transition = null;
                        if (!isInitialTransition) {
                            transition = this.transitions.get(stateCurrent).get(stateDesired);
                            if (transition == null) {
                                if (LOGGER.isLoggable(Level.FINER)) {
                                    LOGGER.finer(String.format("[%s]: Can't find a valid transition from %s to %s.  Ignoring event %s.", this.name, stateCurrent, stateDesired, event));
                                }
                                if (event instanceof LifecycleAwareEvent) {
                                    LifecycleAwareEvent lifecycleAwareEvent4 = (LifecycleAwareEvent)event;
                                    lifecycleAwareEvent4.onFailure(stateCurrent, this, null);
                                }
                                event = null;
                            } else {
                                TransitionAction<S> actionTransition = transition.getAction();
                                if (actionTransition != null) {
                                    try {
                                        actionTransition.onTransition(transition.getName(), stateCurrent, transition.getEndingState(), event, this);
                                    }
                                    catch (RollbackTransitionException e) {
                                        if (LOGGER.isLoggable(Level.FINER)) {
                                            LOGGER.finer(String.format("[%s]: Transition for event %s from %s to %s has been rolledback due to:\n%s", this.name, event, stateCurrent, stateDesired, e));
                                        }
                                        if (event instanceof LifecycleAwareEvent) {
                                            lifecycleAwareEvent = (LifecycleAwareEvent)event;
                                            lifecycleAwareEvent.onFailure(stateCurrent, this, e);
                                        }
                                        event = null;
                                    }
                                    catch (RuntimeException e) {
                                        if (!this.ignoreRuntimeExceptions) {
                                            this.isAcceptingEvents.set(false);
                                            this.allowTransitions.set(false);
                                            if (LOGGER.isLoggable(Level.WARNING)) {
                                                writerString = new StringWriter();
                                                PrintWriter writerPrint = new PrintWriter(writerString);
                                                e.printStackTrace(writerPrint);
                                                writerPrint.close();
                                                LOGGER.warning(String.format("[%s]: Stopping the machine as the Transition Action %s for event %s from %s to %s raised runtime exception %s:\n%s", this.name, actionTransition, event, stateCurrent, stateDesired, e, writerString.toString()));
                                            }
                                            if (event instanceof LifecycleAwareEvent) {
                                                lifecycleAwareEvent = (LifecycleAwareEvent)event;
                                                lifecycleAwareEvent.onFailure(stateCurrent, this, e);
                                            }
                                            event = null;
                                            break;
                                        }
                                        if (LOGGER.isLoggable(Level.FINER)) {
                                            LOGGER.finer(String.format("[%s]: Transition Action %s for event %s from %s to %s raised runtime exception (continuing with transition and ignoring the exception):\n%s", this.name, actionTransition, event, stateCurrent, stateDesired, e));
                                        }
                                    }
                                }
                            }
                        }
                        if (event == null) continue;
                        if (!isInitialTransition) {
                            StateExitAction<S> actionExit = this.stateExitActions.get(stateCurrent);
                            if (actionExit != null) {
                                try {
                                    actionExit.onExitState(stateCurrent, event, this);
                                    break block53;
                                }
                                catch (RuntimeException e) {
                                    if (this.ignoreRuntimeExceptions) {
                                        if (LOGGER.isLoggable(Level.FINER)) {
                                            LOGGER.finer(String.format("[%s]: State Exit Action %s for event %s from %s to %s raised runtime exception (continuing with transition and ignoring the exception):\n%s", this.name, actionExit, event, stateCurrent, stateDesired, e));
                                        }
                                        break block53;
                                    }
                                    this.isAcceptingEvents.set(false);
                                    this.allowTransitions.set(false);
                                    if (LOGGER.isLoggable(Level.WARNING)) {
                                        writerString = new StringWriter();
                                        PrintWriter writerPrint = new PrintWriter(writerString);
                                        e.printStackTrace(writerPrint);
                                        writerPrint.close();
                                        LOGGER.warning(String.format("[%s]: Stopping the machine as the State Exit Action %s for event %s from %s to %s raised runtime exception %s:\n%s", this.name, actionExit, event, stateCurrent, stateDesired, e, writerString.toString()));
                                    }
                                    if (event instanceof LifecycleAwareEvent) {
                                        lifecycleAwareEvent = (LifecycleAwareEvent)event;
                                        lifecycleAwareEvent.onFailure(stateCurrent, this, e);
                                    }
                                    event = null;
                                    break;
                                }
                            }
                            if (LOGGER.isLoggable(Level.FINER)) {
                                LOGGER.finer(String.format("[%s]: No Exit Action defined for %s", this.name, stateCurrent));
                            }
                        }
                    }
                    this.state = stateDesired;
                    if (!isInitialTransition) {
                        this.transitionCount.incrementAndGet();
                    }
                    instruction = Instruction.NOTHING;
                    StateEntryAction<S> actionEntry = this.stateEntryActions.get(stateDesired);
                    if (actionEntry != null) {
                        try {
                            instruction = actionEntry.onEnterState(stateCurrent, stateDesired, event, this);
                            break block54;
                        }
                        catch (RuntimeException e) {
                            if (this.ignoreRuntimeExceptions) {
                                if (LOGGER.isLoggable(Level.FINER)) {
                                    LOGGER.finer(String.format("[%s]: State Entry Action %s for event %s from %s to %s raised runtime exception (continuing and ignoring the exception):\n%s", this.name, actionEntry, event, stateCurrent, stateDesired, e));
                                }
                                break block54;
                            }
                            this.isAcceptingEvents.set(false);
                            this.allowTransitions.set(false);
                            if (LOGGER.isLoggable(Level.WARNING)) {
                                StringWriter writerString = new StringWriter();
                                PrintWriter writerPrint = new PrintWriter(writerString);
                                e.printStackTrace(writerPrint);
                                writerPrint.close();
                                LOGGER.warning(String.format("[%s]: Stopping the machine as the State Entry Action %s for event %s from %s to %s raised runtime exception %s:\n%s", this.name, actionEntry, event, stateCurrent, stateDesired, e, writerString.toString()));
                            }
                            if (event instanceof LifecycleAwareEvent) {
                                LifecycleAwareEvent lifecycleAwareEvent5 = (LifecycleAwareEvent)event;
                                lifecycleAwareEvent5.onFailure(stateCurrent, this, e);
                            }
                            event = null;
                            break;
                        }
                    }
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.finer(String.format("[%s]: No Entry Action defined for %s", this.name, stateDesired));
                    }
                }
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer(String.format("[%s]: State changed to %s. There are %d remaining events to process", this.name, stateDesired, this.pendingEventCount.get()));
                }
                if (event instanceof LifecycleAwareEvent) {
                    lifecycleAwareEvent = (LifecycleAwareEvent)event;
                    lifecycleAwareEvent.onProcessed(stateDesired, this);
                }
                if (instruction == null || instruction == Instruction.NOTHING) {
                    event = null;
                    continue;
                }
                if (instruction == Instruction.STOP) {
                    this.stop();
                    continue;
                }
                if (instruction instanceof Instruction.TransitionTo) {
                    Instruction.TransitionTo eventTransitionTo = (Instruction.TransitionTo)instruction;
                    event = this.prepareEvent(eventTransitionTo);
                    continue;
                }
                if (instruction instanceof DelayedTransitionTo) {
                    DelayedTransitionTo eventDelayedTransitionTo = (DelayedTransitionTo)instruction;
                    this.processLater(eventDelayedTransitionTo, eventDelayedTransitionTo.getDuration(), eventDelayedTransitionTo.getTimeUnit());
                    event = null;
                    continue;
                }
                if (instruction instanceof Instruction.ProcessEvent) {
                    Instruction.ProcessEvent eventDelegating = (Instruction.ProcessEvent)instruction;
                    event = this.prepareEvent(eventDelegating.getEvent());
                    continue;
                }
                if (instruction instanceof ProcessEventLater) {
                    ProcessEventLater eventDelayedInstruction = (ProcessEventLater)instruction;
                    this.processLater(eventDelayedInstruction.getEvent(), eventDelayedInstruction.getDuration(), eventDelayedInstruction.getTimeUnit());
                    event = null;
                    continue;
                }
                if (!LOGGER.isLoggable(Level.FINER)) continue;
                LOGGER.finer(String.format("[%s]: Ignoring Instruction [%s] returned as part of transition to %s as it an unknown type for this Finite State Machine.", this.name, instruction, stateDesired));
            }
            if (!this.isAcceptingEvents.get() && this.pendingEventCount.get() == 0) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer(String.format("[%s]: Completed processing events", this.name));
                }
                this.notifyAll();
            }
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.exiting(this.getClass().getName(), String.format("[%s]: processEvent", this.getName()));
        }
    }

    public static class SubsequentEvent<S extends Enum<S>>
    implements LifecycleAwareEvent<S> {
        private long transitionCount = -1L;
        private Event<S> event;

        public SubsequentEvent(Event<S> event) {
            this.event = event;
        }

        @Override
        public boolean onAccept(ExecutionContext context) {
            this.transitionCount = context.getTransitionCount();
            return this.event instanceof LifecycleAwareEvent ? ((LifecycleAwareEvent)this.event).onAccept(context) : true;
        }

        @Override
        public void onProcessed(S enteredState, ExecutionContext context) {
            if (this.event instanceof LifecycleAwareEvent) {
                ((LifecycleAwareEvent)this.event).onProcessed(enteredState, context);
            }
        }

        @Override
        public void onProcessing(S exitingState, ExecutionContext context) {
            if (this.event instanceof LifecycleAwareEvent) {
                ((LifecycleAwareEvent)this.event).onProcessing(exitingState, context);
            }
        }

        @Override
        public void onFailure(S currentState, ExecutionContext context, Exception exception) {
            if (this.event instanceof LifecycleAwareEvent) {
                ((LifecycleAwareEvent)this.event).onFailure(currentState, context, exception);
            }
        }

        @Override
        public S getDesiredState(S currentState, ExecutionContext context) {
            if (context.getTransitionCount() == this.transitionCount) {
                return this.event.getDesiredState(currentState, context);
            }
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(String.format("[%s]: Skipping event %s as another event was interleaved between when it was scheduled and when it was processed", context.getName(), this));
            }
            return null;
        }

        public String toString() {
            return String.format("SubsequentEvent{%s, @Transition #%d}", this.event, this.transitionCount + 1L);
        }
    }

    public static class ProcessEventLater<S extends Enum<S>>
    implements Instruction {
        private Event<S> event;
        private long duration;
        private TimeUnit timeUnit;

        public ProcessEventLater(Event<S> event) {
            this(event, 0L, TimeUnit.MILLISECONDS);
        }

        public ProcessEventLater(Event<S> event, long duration, TimeUnit timeUnit) {
            this.event = event;
            this.duration = duration;
            this.timeUnit = timeUnit;
        }

        public Event<S> getEvent() {
            return this.event;
        }

        public long getDuration() {
            return this.duration;
        }

        public TimeUnit getTimeUnit() {
            return this.timeUnit;
        }
    }

    public static class DelayedTransitionTo<S extends Enum<S>>
    implements Instruction,
    Event<S> {
        private S desiredState;
        private long duration;
        private TimeUnit timeUnit;

        public DelayedTransitionTo(S desiredState) {
            this(desiredState, 0L, TimeUnit.MILLISECONDS);
        }

        public DelayedTransitionTo(S desiredState, long duration, TimeUnit timeUnit) {
            this.desiredState = desiredState;
            this.duration = duration;
            this.timeUnit = timeUnit;
        }

        @Override
        public S getDesiredState(S currentState, ExecutionContext context) {
            return this.desiredState;
        }

        public long getDuration() {
            return this.duration;
        }

        public TimeUnit getTimeUnit() {
            return this.timeUnit;
        }
    }

    public static class CoalescedEvent<S extends Enum<S>>
    implements LifecycleAwareEvent<S> {
        private static ConcurrentHashMap<Discriminator, Event<?>> s_eventsByDiscriminator = new ConcurrentHashMap();
        private Object discriminator;
        private Event<S> event;
        private Process mode;
        private Event<S> eventChosen;

        public CoalescedEvent(Event<S> event) {
            this(event, Process.FIRST, event.getClass());
        }

        public CoalescedEvent(Event<S> event, Process mode) {
            this(event, mode, event.getClass());
        }

        public CoalescedEvent(Event<S> event, Process mode, Object discriminator) {
            this.discriminator = discriminator == null ? Void.class : discriminator;
            this.event = event;
            this.mode = mode;
            this.eventChosen = null;
        }

        @Override
        public S getDesiredState(S state, ExecutionContext context) {
            this.eventChosen = s_eventsByDiscriminator.remove(this.discriminator);
            if (this.eventChosen == null) {
                return null;
            }
            return this.eventChosen.getDesiredState(state, context);
        }

        @Override
        public boolean onAccept(ExecutionContext context) {
            if (context instanceof NonBlockingFiniteStateMachine) {
                boolean fIsAccepted = this.event instanceof LifecycleAwareEvent ? ((LifecycleAwareEvent)this.event).onAccept(context) : true;
                Discriminator discriminator = new Discriminator((NonBlockingFiniteStateMachine)context, this.discriminator);
                this.discriminator = discriminator;
                if (fIsAccepted) {
                    fIsAccepted = this.mode == Process.FIRST ? s_eventsByDiscriminator.putIfAbsent(discriminator, this.event) == null : s_eventsByDiscriminator.put(discriminator, this.event) == null;
                }
                return fIsAccepted;
            }
            throw new UnsupportedOperationException(String.format("CoalescingEvents may only be used with %s instance", NonBlockingFiniteStateMachine.class.getName()));
        }

        @Override
        public void onProcessed(S enteredState, ExecutionContext context) {
            if (this.eventChosen instanceof LifecycleAwareEvent) {
                ((LifecycleAwareEvent)this.eventChosen).onProcessed(enteredState, context);
            }
        }

        @Override
        public void onProcessing(S exitingState, ExecutionContext context) {
            if (this.eventChosen instanceof LifecycleAwareEvent) {
                ((LifecycleAwareEvent)this.eventChosen).onProcessing(exitingState, context);
            }
        }

        @Override
        public void onFailure(S currentState, ExecutionContext context, Exception exception) {
            if (this.eventChosen instanceof LifecycleAwareEvent) {
                ((LifecycleAwareEvent)this.eventChosen).onFailure(currentState, context, exception);
            }
        }

        public String toString() {
            return String.format("CoalescedEvent{%s, discriminator=%s, mode=%s}", new Object[]{this.event, this.discriminator, this.mode});
        }

        public static class Discriminator {
            private NonBlockingFiniteStateMachine<?> machine;
            private Object discriminator;

            public Discriminator(NonBlockingFiniteStateMachine<?> machine, Object discriminator) {
                this.machine = machine;
                this.discriminator = discriminator;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.discriminator == null ? 0 : this.discriminator.hashCode());
                result = 31 * result + (this.machine == null ? 0 : this.machine.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Discriminator other = (Discriminator)obj;
                if (this.discriminator == null ? other.discriminator != null : !this.discriminator.equals(other.discriminator)) {
                    return false;
                }
                return !(this.machine == null ? other.machine != null : !this.machine.equals(other.machine));
            }
        }

        public static enum Process {
            FIRST,
            MOST_RECENT;

        }
    }
}

