/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.finitestatemachines;

import com.oracle.coherence.common.finitestatemachines.Model;
import com.oracle.coherence.common.finitestatemachines.Transition;

public class Render {
    public static <S extends Enum<S>> String asGraphViz(Model<S> model) {
        StringBuilder builder = new StringBuilder();
        builder.append("digraph finite_state_machine {\n");
        builder.append("    rankdir=LR;\n");
        builder.append("    node [shape=circle];\n");
        for (Enum state : model.getStates()) {
            builder.append("    " + state.name() + " [ label=\"" + state.name() + "\" ];\n");
        }
        for (Enum state : model.getStates()) {
            for (Transition<Enum> transition : model.getTransitions()) {
                if (!transition.isStartingState(state)) continue;
                builder.append("    " + state.name() + " -> " + ((Enum)transition.getEndingState()).name() + "[ label=\"" + transition.getName() + "\" ];\n");
            }
        }
        builder.append("}\n");
        return builder.toString();
    }
}

