/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.finitestatemachines;

public class RollbackTransitionException
extends Exception {
    private Enum<?> m_stateFrom;
    private Enum<?> m_stateTo;

    public RollbackTransitionException(Enum<?> stateFrom, Enum<?> stateTo, String rationale) {
        super(String.format("Rollback of transition from %s to %s occurred. %s", stateFrom, stateTo, rationale));
        this.m_stateFrom = stateFrom;
        this.m_stateTo = stateTo;
    }

    public RollbackTransitionException(Enum<?> stateFrom, Enum<?> stateTo, Throwable cause) {
        super(String.format("Rollback of transition from %s to %s occured due to an exception.", stateFrom, stateTo), cause);
        this.m_stateFrom = stateFrom;
        this.m_stateTo = stateTo;
    }

    public Enum<?> getStateFrom() {
        return this.m_stateFrom;
    }

    public Enum<?> getStateTo() {
        return this.m_stateTo;
    }
}

