/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.finitestatemachines;

import com.oracle.coherence.common.finitestatemachines.Model;
import com.oracle.coherence.common.finitestatemachines.StateEntryAction;
import com.oracle.coherence.common.finitestatemachines.StateExitAction;
import com.oracle.coherence.common.finitestatemachines.Transition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class SimpleModel<S extends Enum<S>>
implements Model<S> {
    private Class<S> m_stateClass;
    private S[] m_states;
    private ArrayList<Transition<S>> m_transitions;
    private HashMap<S, StateEntryAction<S>> m_stateEntryActions;
    private HashMap<S, StateExitAction<S>> m_stateExitActions;

    public SimpleModel(Class<S> stateClass) {
        this.m_stateClass = stateClass;
        this.m_states = (Enum[])stateClass.getEnumConstants();
        this.m_transitions = new ArrayList();
        this.m_stateEntryActions = new HashMap();
        this.m_stateExitActions = new HashMap();
    }

    @Override
    public Class<S> getStateClass() {
        return this.m_stateClass;
    }

    @Override
    public S[] getStates() {
        return this.m_states;
    }

    public S getState(String name) {
        name = name.trim().toUpperCase();
        for (S state : this.m_states) {
            if (!((Enum)state).name().toUpperCase().equals(name)) continue;
            return state;
        }
        return null;
    }

    @Override
    public Map<S, StateEntryAction<S>> getStateEntryActions() {
        return this.m_stateEntryActions;
    }

    public void addStateEntryAction(S state, StateEntryAction<S> stateEntryAction) {
        this.m_stateEntryActions.put(state, stateEntryAction);
    }

    @Override
    public Map<S, StateExitAction<S>> getStateExitActions() {
        return this.m_stateExitActions;
    }

    public void addStateExitAction(S state, StateExitAction<S> stateExitAction) {
        this.m_stateExitActions.put(state, stateExitAction);
    }

    @Override
    public Iterable<Transition<S>> getTransitions() {
        return this.m_transitions;
    }

    public void addTransition(Transition<S> transition) {
        this.m_transitions.add(transition);
    }
}

