/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.finitestatemachines;

import com.oracle.coherence.common.finitestatemachines.TransitionAction;
import java.util.EnumSet;

public class Transition<S extends Enum<S>> {
    private String m_name;
    private EnumSet<S> m_statesFrom;
    private S m_stateTo;
    private TransitionAction<S> m_action;

    public Transition(String name, EnumSet<S> statesFrom, S stateTo) {
        this(name, statesFrom, (EnumSet<S>)stateTo, (TransitionAction<EnumSet<S>>)null);
    }

    public Transition(String name, S stateFrom, S stateTo) {
        this(name, stateFrom, stateTo, null);
    }

    public Transition(String name, EnumSet<S> statesFrom, S stateTo, TransitionAction<S> action) {
        this.m_name = name;
        this.m_statesFrom = statesFrom;
        this.m_stateTo = stateTo;
        this.m_action = action;
    }

    public Transition(String name, S stateFrom, S stateTo, TransitionAction<S> action) {
        this.m_name = name;
        this.m_statesFrom = EnumSet.of(stateFrom);
        this.m_stateTo = stateTo;
        this.m_action = action;
    }

    public String getName() {
        return this.m_name;
    }

    public boolean isStartingState(S state) {
        return this.m_statesFrom.contains(state);
    }

    public TransitionAction<S> getAction() {
        return this.m_action;
    }

    public S getEndingState() {
        return this.m_stateTo;
    }

    public String toString() {
        return String.format("Transition{name=%s, from=%s, to=%s, action=%s}", this.m_name, this.m_statesFrom, this.m_stateTo, this.m_action);
    }
}

