/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.identifiers;

import com.oracle.coherence.common.identifiers.Identifier;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class IntegerBasedIdentifier
implements Identifier,
ExternalizableLite,
PortableObject {
    private int value;

    public IntegerBasedIdentifier() {
    }

    private IntegerBasedIdentifier(int value) {
        this.value = value;
    }

    public static Identifier newInstance(int value) {
        return new IntegerBasedIdentifier(value);
    }

    public int getint() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntegerBasedIdentifier other = (IntegerBasedIdentifier)obj;
        return this.value == other.value;
    }

    public String toString() {
        return String.format("Identifier{%d}", this.value);
    }

    public void readExternal(DataInput in) throws IOException {
        this.value = ExternalizableHelper.readInt((DataInput)in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeInt((DataOutput)out, (int)this.value);
    }

    public void readExternal(PofReader reader) throws IOException {
        this.value = reader.readInt(0);
    }

    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeInt(0, this.value);
    }
}

