/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.identifiers;

import com.oracle.coherence.common.identifiers.Identifier;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class LongBasedIdentifier
implements Identifier,
ExternalizableLite,
PortableObject {
    private long value;

    public LongBasedIdentifier() {
    }

    private LongBasedIdentifier(long value) {
        this.value = value;
    }

    public static Identifier newInstance(long value) {
        return new LongBasedIdentifier(value);
    }

    public long getlong() {
        return this.value;
    }

    public String toString() {
        return String.format("Identifier{%d}", this.value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.value ^ this.value >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LongBasedIdentifier other = (LongBasedIdentifier)obj;
        return this.value == other.value;
    }

    public void readExternal(DataInput in) throws IOException {
        this.value = ExternalizableHelper.readLong((DataInput)in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.value);
    }

    public void readExternal(PofReader reader) throws IOException {
        this.value = reader.readLong(0);
    }

    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeLong(0, this.value);
    }
}

