/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.leasing;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Lease
implements ExternalizableLite,
PortableObject {
    private static final Logger logger = Logger.getLogger(Lease.class.getName());
    private long acquisitionTime;
    private long lastUpdateTime;
    private long duration;

    public Lease() {
        this.acquisitionTime = 0L;
        this.lastUpdateTime = 0L;
        this.duration = 0L;
    }

    Lease(long duration) {
        this.lastUpdateTime = this.acquisitionTime = System.currentTimeMillis();
        this.duration = duration;
    }

    Lease(long acqusitionTime, long duration) {
        this.acquisitionTime = acqusitionTime;
        this.lastUpdateTime = acqusitionTime;
        this.duration = duration;
    }

    public long getAcquisitionTime() {
        return this.acquisitionTime;
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public long getDuration() {
        return this.duration;
    }

    public boolean isCanceled() {
        return this.duration == -1L;
    }

    public void setIsCanceled(boolean cancel) {
        if (!this.isCanceled() && cancel) {
            this.lastUpdateTime = System.currentTimeMillis();
        }
        this.duration = -1L;
    }

    public boolean isSuspended() {
        return this.duration == -2L;
    }

    public void setIsSuspended(boolean suspend) {
        if (!this.isCanceled() && !this.isSuspended() && suspend) {
            this.lastUpdateTime = System.currentTimeMillis();
            this.duration = -2L;
        }
    }

    public boolean isIndefinite() {
        return this.duration == -3L;
    }

    public boolean isValidAt(long time) {
        return this.isIndefinite() || !this.isCanceled() && !this.isSuspended() && this.lastUpdateTime + this.duration >= time;
    }

    public boolean extend(long duration) {
        if (this.isIndefinite()) {
            this.lastUpdateTime = System.currentTimeMillis();
            return true;
        }
        if (this.isCanceled()) {
            return false;
        }
        if (duration >= 0L) {
            this.duration = duration;
            this.lastUpdateTime = System.currentTimeMillis();
            return true;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(String.format("Attempted to extend %s by a negative duration %d. Ignoring request", this, duration));
        }
        return false;
    }

    public boolean extend() {
        return this.extend(this.getDuration());
    }

    public void readExternal(DataInput in) throws IOException {
        this.acquisitionTime = ExternalizableHelper.readLong((DataInput)in);
        this.lastUpdateTime = ExternalizableHelper.readLong((DataInput)in);
        this.duration = ExternalizableHelper.readLong((DataInput)in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.acquisitionTime);
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.lastUpdateTime);
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.duration);
    }

    public void readExternal(PofReader reader) throws IOException {
        this.acquisitionTime = reader.readLong(0);
        this.lastUpdateTime = reader.readLong(1);
        this.duration = reader.readLong(2);
    }

    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeLong(0, this.acquisitionTime);
        writer.writeLong(1, this.lastUpdateTime);
        writer.writeLong(2, this.duration);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Lease)) {
            return false;
        }
        Lease other = (Lease)obj;
        if (this.acquisitionTime != other.acquisitionTime) {
            return false;
        }
        if (this.duration != other.duration) {
            return false;
        }
        return this.lastUpdateTime == other.lastUpdateTime;
    }

    public String toString() {
        if (this.isIndefinite()) {
            return String.format("Lease{acquistionTime=%s, lastUpdateTime=%s, duration=INDEFINITE}", new Date(this.acquisitionTime), new Date(this.lastUpdateTime));
        }
        if (this.isSuspended()) {
            return String.format("Lease{acquistionTime=%s, lastUpdateTime=%s, duration=SUSPENDED}", new Date(this.acquisitionTime), new Date(this.lastUpdateTime));
        }
        if (this.isCanceled()) {
            return String.format("Lease{acquistionTime=%s, lastUpdateTime=%s, duration=CANCELED}", new Date(this.acquisitionTime), new Date(this.lastUpdateTime));
        }
        return String.format("Lease{acquistionTime=%s, lastUpdateTime=%s, duration=%d}", new Date(this.acquisitionTime), new Date(this.lastUpdateTime), this.duration);
    }
}

