/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.leasing;

import com.oracle.coherence.common.leasing.Lease;
import com.oracle.coherence.common.leasing.LeaseListener;
import com.oracle.coherence.common.threading.ExecutorServiceFactory;
import com.oracle.coherence.common.threading.ThreadFactories;
import com.oracle.coherence.common.tuples.Pair;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LeaseExpiryCoordinator {
    private static final Logger logger = Logger.getLogger(LeaseExpiryCoordinator.class.getName());
    public static final LeaseExpiryCoordinator INSTANCE = new LeaseExpiryCoordinator(1000L);
    private ScheduledExecutorService executorService = ExecutorServiceFactory.newSingleThreadScheduledExecutor(ThreadFactories.newThreadFactory(true, "LeaseCoordinator", null));
    private ConcurrentHashMap<Object, Pair<Lease, LeaseListener>> leases = new ConcurrentHashMap();

    public LeaseExpiryCoordinator(long leaseValidityCheckingDelay) {
        this.executorService.scheduleAtFixedRate(new LeaseValidator(), leaseValidityCheckingDelay, leaseValidityCheckingDelay, TimeUnit.MILLISECONDS);
    }

    public void registerLease(Object leaseOwner, Lease lease, LeaseListener leaseExpiryListener) {
        this.leases.put(leaseOwner, new Pair<Lease, LeaseListener>(lease, leaseExpiryListener));
    }

    public void deregisterLease(Object leaseOwner) {
        this.leases.remove(leaseOwner);
    }

    private class LeaseValidator
    implements Runnable {
        private LeaseValidator() {
        }

        @Override
        public void run() {
            try {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(String.format("Validating %d Lease(s)", LeaseExpiryCoordinator.this.leases.size()));
                }
                long currentTime = System.currentTimeMillis();
                LinkedList expiredLeaseOwners = null;
                for (Object leaseOwner : LeaseExpiryCoordinator.this.leases.keySet()) {
                    Pair pair = (Pair)LeaseExpiryCoordinator.this.leases.get(leaseOwner);
                    Lease lease = (Lease)pair.getX();
                    LeaseListener leaseListener = (LeaseListener)pair.getY();
                    boolean deregisterLease = false;
                    if (lease.isCanceled()) {
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest(String.format("%s for %s has been canceled", lease, leaseOwner));
                        }
                        if (leaseListener != null) {
                            leaseListener.onLeaseCanceled(leaseOwner, lease);
                        }
                        deregisterLease = true;
                    } else if (lease.isSuspended()) {
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest(String.format("%s for %s has been suspended", lease, leaseOwner));
                        }
                        if (leaseListener != null) {
                            leaseListener.onLeaseSuspended(leaseOwner, lease);
                        }
                        deregisterLease = true;
                    } else if (!lease.isValidAt(currentTime)) {
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest(String.format("%s for %s has expired", lease, leaseOwner));
                        }
                        if (leaseListener != null) {
                            leaseListener.onLeaseExpiry(leaseOwner, lease);
                        }
                        deregisterLease = true;
                    }
                    if (!deregisterLease) continue;
                    if (expiredLeaseOwners == null) {
                        expiredLeaseOwners = new LinkedList();
                    }
                    expiredLeaseOwners.add(leaseOwner);
                }
                if (expiredLeaseOwners != null) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest(String.format("Deregistering %d Lease(s)", expiredLeaseOwners.size()));
                    }
                    for (Object leaseOwner : expiredLeaseOwners) {
                        LeaseExpiryCoordinator.this.deregisterLease(leaseOwner);
                    }
                }
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, String.format("LeaseValidator Failed due to\n%s\n", exception));
            }
        }
    }
}

