/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.logging;

import com.tangosol.net.CacheFactory;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class CoherenceLogHandler
extends Handler {
    private Level currentLogLevel = this.determineLogLevel();

    private Level determineLogLevel() {
        if (CacheFactory.isLogEnabled((int)9)) {
            return Level.FINEST;
        }
        if (CacheFactory.isLogEnabled((int)8)) {
            return Level.FINEST;
        }
        if (CacheFactory.isLogEnabled((int)7)) {
            return Level.FINEST;
        }
        if (CacheFactory.isLogEnabled((int)6)) {
            return Level.FINER;
        }
        if (CacheFactory.isLogEnabled((int)5)) {
            return Level.FINE;
        }
        if (CacheFactory.isLogEnabled((int)4)) {
            return Level.CONFIG;
        }
        if (CacheFactory.isLogEnabled((int)3)) {
            return Level.INFO;
        }
        if (CacheFactory.isLogEnabled((int)2)) {
            return Level.WARNING;
        }
        if (CacheFactory.isLogEnabled((int)1)) {
            return Level.SEVERE;
        }
        if (CacheFactory.isLogEnabled((int)0)) {
            return Level.ALL;
        }
        return Level.ALL;
    }

    public static void initializeIncubatorLogging() {
        Logger logger = Logger.getLogger("com.oracle.coherence");
        CoherenceLogHandler handler = new CoherenceLogHandler();
        logger.addHandler(handler);
        logger.setUseParentHandlers(false);
        logger.setLevel(((Handler)handler).getLevel());
    }

    @Override
    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            Level level = this.getEffectiveLevel(Logger.getLogger(record.getLoggerName()));
            if (level == null) {
                return;
            }
            record.setLevel(Level.ALL);
        }
        StringBuilder sb = new StringBuilder(record.getMessage());
        if (record.getSourceClassName() != null) {
            sb.append(" Class:");
            sb.append(record.getSourceClassName());
        }
        if (record.getSourceMethodName() != null) {
            sb.append(" Method:");
            sb.append(record.getSourceMethodName());
        }
        String msgToLog = null;
        msgToLog = record.getParameters() != null ? MessageFormat.format(sb.toString(), record.getParameters()) : sb.toString();
        if (record.getThrown() != null) {
            StringWriter stringWriter = new StringWriter();
            record.getThrown().printStackTrace(new PrintWriter(stringWriter));
            CacheFactory.log((String)(msgToLog + "\n" + stringWriter.toString()), (int)this.translateLogLevelToCoherence(record.getLevel()));
        } else {
            CacheFactory.log((String)msgToLog, (int)this.translateLogLevelToCoherence(record.getLevel()));
        }
    }

    public Level getEffectiveLevel(Logger logger) {
        Level eLevel;
        Level effectiveLevel = logger.getLevel();
        if (effectiveLevel == null && (eLevel = this.getEffectiveLevel(logger.getParent())) != null) {
            effectiveLevel = eLevel;
        }
        return effectiveLevel;
    }

    @Override
    public Level getLevel() {
        return this.currentLogLevel;
    }

    private int translateLogLevelToCoherence(Level level) {
        switch (level.intValue()) {
            case -2147483648: {
                return 0;
            }
            case 1000: {
                return 1;
            }
            case 900: {
                return 2;
            }
            case 800: {
                return 3;
            }
            case 700: {
                return 3;
            }
            case 500: {
                return 5;
            }
            case 400: {
                return 6;
            }
            case 300: {
                return 7;
            }
            case 0x7FFFFFFF: {
                return 9;
            }
        }
        return 0;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }
}

