/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.logging;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LogHelper {
    public static void entering(Logger logger, String sourceClass, String sourceMethod) {
        if (!logger.isLoggable(Level.FINEST)) {
            return;
        }
        LogRecord record = new LogRecord(Level.FINEST, "ENTRY");
        record.setLoggerName(logger.getName());
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        logger.log(record);
    }

    public static void entering(Logger logger, String sourceClass, String sourceMethod, Object param) {
        if (!logger.isLoggable(Level.FINEST)) {
            return;
        }
        LogRecord record = new LogRecord(Level.FINEST, "ENTRY {0}");
        record.setLoggerName(logger.getName());
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        record.setParameters(new Object[]{param});
        logger.log(record);
    }

    public static void entering(Logger logger, String sourceClass, String sourceMethod, Object[] params) {
        if (!logger.isLoggable(Level.FINEST)) {
            return;
        }
        String msg = "ENTRY";
        if (params != null) {
            StringBuilder msgBuffer = new StringBuilder("ENTRY");
            for (int i = 0; i < params.length; ++i) {
                msgBuffer.append(" {").append(i).append("}");
            }
            msg = msgBuffer.toString();
        }
        LogRecord record = new LogRecord(Level.FINEST, msg);
        record.setLoggerName(logger.getName());
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        record.setParameters(params);
        logger.log(record);
    }

    public static void exiting(Logger logger, String sourceClass, String sourceMethod) {
        if (!logger.isLoggable(Level.FINEST)) {
            return;
        }
        LogRecord record = new LogRecord(Level.FINEST, "RETURN");
        record.setLoggerName(logger.getName());
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        logger.log(record);
    }

    public static void exiting(Logger logger, String sourceClass, String sourceMethod, Object result) {
        if (!logger.isLoggable(Level.FINEST)) {
            return;
        }
        LogRecord record = new LogRecord(Level.FINEST, "RETURN {0}");
        record.setLoggerName(logger.getName());
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        record.setParameters(new Object[]{result});
        logger.log(record);
    }

    public static void throwing(Logger logger, String sourceClass, String sourceMethod, Throwable thrown) {
        if (!logger.isLoggable(Level.FINEST)) {
            return;
        }
        LogRecord record = new LogRecord(Level.FINEST, "THROW");
        record.setLoggerName(logger.getName());
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        record.setThrown(thrown);
        logger.log(record);
    }
}

