/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.network;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.NoSuchElementException;

@Deprecated
public class AvailablePortIterator
implements Iterator<Integer> {
    private static final int MINIMUM_PORT = 1;
    private static final int MAXIMUM_PORT = 65535;
    private InetAddress inetAddress;
    private int portRangeStart;
    private int portRangeEnd;
    private int nextAvailablePort;

    public AvailablePortIterator() throws UnknownHostException {
        this(InetAddress.getByName("localhost"), 1, 65535);
    }

    public AvailablePortIterator(int portRangeStart) throws UnknownHostException {
        this(InetAddress.getByName("localhost"), portRangeStart, 65535);
    }

    public AvailablePortIterator(int portRangeStart, int portRangeEnd) throws UnknownHostException {
        this(InetAddress.getByName("localhost"), portRangeStart, portRangeEnd);
    }

    public AvailablePortIterator(InetAddress inetAddress, int portRangeStart, int portRangeEnd) {
        this.inetAddress = inetAddress;
        this.portRangeStart = portRangeStart;
        this.portRangeEnd = portRangeEnd;
        this.nextAvailablePort = this.nextAvailablePortAfter(portRangeStart - 1);
    }

    public AvailablePortIterator(String host, int portRangeStart, int portRangeEnd) throws UnknownHostException {
        this(InetAddress.getByName(host), portRangeStart, portRangeEnd);
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPortAvailable(int port) {
        if (port < this.portRangeStart || port > this.portRangeEnd) {
            return false;
        }
        ServerSocket serverSocket = null;
        DatagramSocket datagramSocket = null;
        try {
            serverSocket = new ServerSocket(port, 1, this.inetAddress);
            serverSocket.setReuseAddress(true);
            datagramSocket = new DatagramSocket(port, this.inetAddress);
            datagramSocket.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException ioException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (datagramSocket != null) {
                datagramSocket.close();
            }
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (IOException ioException) {}
            }
        }
    }

    private int nextAvailablePortAfter(int port) {
        for (int i = port + 1; i <= this.portRangeEnd; ++i) {
            if (!this.isPortAvailable(i)) continue;
            return i;
        }
        return this.portRangeEnd + 1;
    }

    @Override
    public boolean hasNext() {
        return this.nextAvailablePort <= this.portRangeEnd;
    }

    @Override
    public Integer next() {
        if (this.hasNext()) {
            int result = this.nextAvailablePort;
            this.nextAvailablePort = this.nextAvailablePortAfter(this.nextAvailablePort);
            return result;
        }
        throw new NoSuchElementException("Attempted to iterate outside of the range of available ports");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("It's illegal to attempt to remove() a port from an AvailablePortIterator");
    }
}

