/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.partition;

import com.oracle.coherence.common.partition.PartitionAwareKey;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class PartitionKey
implements PartitionAwareKey,
ExternalizableLite,
PortableObject {
    private int partition;
    private Object embeddedKey;

    public PartitionKey() {
    }

    public PartitionKey(int partition, Object embeddedKey) {
        this.partition = partition;
        this.embeddedKey = embeddedKey;
    }

    public String toString() {
        return "PartitionKey [" + (this.embeddedKey != null ? "embeddedKey=" + this.embeddedKey + ", " : "") + "partition=" + this.partition + "]";
    }

    @Override
    public int getPartition() {
        return this.partition;
    }

    public Object getKey() {
        return this.embeddedKey;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.embeddedKey.hashCode();
        result = 31 * result + this.partition;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PartitionKey other = (PartitionKey)obj;
        if (this.embeddedKey == null ? other.embeddedKey != null : !this.embeddedKey.equals(other.embeddedKey)) {
            return false;
        }
        return this.partition == other.partition;
    }

    public void readExternal(DataInput in) throws IOException {
        this.partition = in.readInt();
        this.embeddedKey = ExternalizableHelper.readObject((DataInput)in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        out.writeInt(this.partition);
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.embeddedKey);
    }

    public void readExternal(PofReader in) throws IOException {
        this.partition = in.readInt(0);
        this.embeddedKey = in.readObject(1);
    }

    public void writeExternal(PofWriter out) throws IOException {
        out.writeInt(0, this.partition);
        out.writeObject(1, this.embeddedKey);
    }
}

