/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.processors;

import com.oracle.coherence.common.util.ReflectionHelper;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.processor.AbstractProcessor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CreateRemoteObjectProcessor
extends AbstractProcessor
implements ExternalizableLite,
PortableObject {
    private static final Logger logger = Logger.getLogger(CreateRemoteObjectProcessor.class.getName());
    private String className;
    protected Object[] parameters;

    public CreateRemoteObjectProcessor() {
    }

    public CreateRemoteObjectProcessor(String classname, Object ... parameters) {
        this.className = classname;
        this.parameters = parameters;
    }

    public Object process(InvocableMap.Entry entry) {
        Class<?> clazz;
        if (entry.isPresent()) {
            return new IllegalStateException("An object with the key " + entry.getKey() + " already exists");
        }
        try {
            clazz = Class.forName(this.className);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.SEVERE, "Exception in process method ", e);
            throw Base.ensureRuntimeException((Throwable)e);
        }
        try {
            Class[] parameterTypes = null;
            if (this.parameters != null) {
                parameterTypes = new Class[this.parameters.length];
                for (int i = 0; i < this.parameters.length; ++i) {
                    parameterTypes[i] = this.parameters[i].getClass();
                }
            }
            Constructor<?> con = ReflectionHelper.getCompatibleConstructor(clazz, parameterTypes);
            Object inst = con.newInstance(this.parameters);
            entry.setValue(inst);
            return null;
        }
        catch (InstantiationException e) {
            return e;
        }
        catch (IllegalAccessException e) {
            return e;
        }
        catch (Exception e) {
            return e;
        }
    }

    public void readExternal(DataInput in) throws IOException {
        this.className = ExternalizableHelper.readUTF((DataInput)in);
        int cParams = ExternalizableHelper.readInt((DataInput)in);
        Object[] aoParam = cParams == 0 ? null : new Object[cParams];
        for (int i = 0; i < cParams; ++i) {
            aoParam[i] = ExternalizableHelper.readObject((DataInput)in);
        }
        this.parameters = aoParam;
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeUTF((DataOutput)out, (String)this.className);
        Object[] aoParam = this.parameters;
        int cParams = aoParam == null ? 0 : aoParam.length;
        ExternalizableHelper.writeInt((DataOutput)out, (int)cParams);
        for (int i = 0; i < cParams; ++i) {
            ExternalizableHelper.writeObject((DataOutput)out, (Object)aoParam[i]);
        }
    }

    public void readExternal(PofReader oReader) throws IOException {
        this.className = oReader.readString(0);
        this.parameters = oReader.readObjectArray(1, null);
    }

    public void writeExternal(PofWriter oWriter) throws IOException {
        oWriter.writeString(0, this.className);
        oWriter.writeObjectArray(1, this.parameters);
    }
}

