/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.processors;

import com.oracle.coherence.common.util.ChangeIndication;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.processor.AbstractProcessor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.NotActiveException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class InvokeMethodProcessor
extends AbstractProcessor
implements ExternalizableLite,
PortableObject {
    protected String methodName;
    protected Object[] parameters;
    private transient Method cachedMethod;

    public InvokeMethodProcessor() {
    }

    public InvokeMethodProcessor(String method) {
        this(method, null);
    }

    public InvokeMethodProcessor(String methodName, Object[] parameters) {
        InvokeMethodProcessor.azzert((methodName != null ? 1 : 0) != 0);
        this.methodName = methodName;
        this.parameters = parameters;
    }

    private Class<?>[] getClassArray() {
        int cParams;
        if (this.parameters != null && (cParams = this.parameters.length) > 0) {
            Class[] aClass = new Class[cParams];
            for (int i = 0; i < cParams; ++i) {
                Object oParam = this.parameters[i];
                if (oParam == null) continue;
                aClass[i] = oParam.getClass();
            }
            return aClass;
        }
        return ClassHelper.VOID_PARAMS;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    private Object invoke(Object oTarget) throws Throwable {
        Class<?> clz = oTarget.getClass();
        try {
            Method method = this.cachedMethod;
            if (method == null || method.getDeclaringClass() != clz) {
                this.cachedMethod = method = ClassHelper.findMethod(clz, (String)this.getMethodName(), (Class[])this.getClassArray(), (boolean)false);
            }
            return method.invoke(oTarget, this.parameters);
        }
        catch (NullPointerException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (InvocationTargetException ex) {
            throw ex.getCause();
        }
        catch (Exception e) {
            throw InvokeMethodProcessor.ensureRuntimeException((Throwable)e, (String)(clz.getName() + (Object)((Object)this) + '(' + oTarget + ')'));
        }
    }

    public Object process(InvocableMap.Entry entry) {
        try {
            Object valueObject = entry.getValue();
            if (valueObject != null) {
                if (valueObject instanceof ChangeIndication) {
                    ChangeIndication objectThatMayChange = (ChangeIndication)valueObject;
                    objectThatMayChange.beforeChange();
                    Object returnValue = this.invoke(objectThatMayChange);
                    if (objectThatMayChange.changed()) {
                        entry.setValue((Object)objectThatMayChange);
                    }
                    return returnValue;
                }
                Object returnValue = this.invoke(valueObject);
                entry.setValue(valueObject);
                return returnValue;
            }
            return new NullPointerException("Tried to execute method:" + this.methodName + " but Entry is null, key:" + entry.getKey());
        }
        catch (Throwable e) {
            return new RuntimeException(e);
        }
    }

    public String toString() {
        Object[] aoParam = this.parameters;
        int cParams = aoParam == null ? 0 : aoParam.length;
        StringBuffer sb = new StringBuffer(this.methodName);
        sb.append('(');
        for (int i = 0; i < cParams; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(String.valueOf(aoParam[i]));
        }
        sb.append(')');
        return sb.toString();
    }

    public void readExternal(DataInput in) throws IOException {
        this.methodName = ExternalizableHelper.readUTF((DataInput)in);
        int cParams = ExternalizableHelper.readInt((DataInput)in);
        Object[] aoParam = cParams == 0 ? null : new Object[cParams];
        for (int i = 0; i < cParams; ++i) {
            aoParam[i] = ExternalizableHelper.readObject((DataInput)in);
        }
        this.parameters = aoParam;
    }

    public void readExternal(PofReader in) throws IOException {
        this.methodName = in.readString(0);
        this.parameters = in.readObjectArray(1, null);
    }

    public void writeExternal(DataOutput out) throws IOException {
        String sMethod = this.methodName;
        if (sMethod == null) {
            throw new NotActiveException("MethodInvokerProcessor was constructed without a method name");
        }
        Object[] aoParam = this.parameters;
        int cParams = aoParam == null ? 0 : aoParam.length;
        ExternalizableHelper.writeUTF((DataOutput)out, (String)sMethod);
        ExternalizableHelper.writeInt((DataOutput)out, (int)cParams);
        for (int i = 0; i < cParams; ++i) {
            ExternalizableHelper.writeObject((DataOutput)out, (Object)aoParam[i]);
        }
    }

    public void writeExternal(PofWriter out) throws IOException {
        String sMethod = this.methodName;
        if (sMethod == null) {
            throw new NotActiveException("MethodInvokerProcessor was constructed without a method name");
        }
        out.writeString(0, sMethod);
        out.writeObjectArray(1, this.parameters);
    }
}

