/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.ranges;

import com.oracle.coherence.common.ranges.InfiniteRange;
import com.oracle.coherence.common.ranges.NotComparableRuntimeException;
import com.oracle.coherence.common.ranges.Range;
import com.oracle.coherence.common.ranges.SparseRange;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;

public class ContiguousRange
implements Range,
ExternalizableLite,
PortableObject,
Iterable<Long>,
Comparable<Range> {
    private long from;
    private long to;

    public ContiguousRange() {
        this.from = 0L;
        this.to = this.from - 1L;
    }

    ContiguousRange(long from) {
        this.from = from;
        this.to = from - 1L;
    }

    ContiguousRange(long from, long to) {
        this.from = from;
        this.to = to;
    }

    @Override
    public long getFrom() {
        return this.from;
    }

    @Override
    public long getTo() {
        return this.to;
    }

    @Override
    public long size() {
        return this.isEmpty() ? 0L : this.to - this.from + 1L;
    }

    @Override
    public boolean isEmpty() {
        return this.from > this.to;
    }

    @Override
    public boolean isSingleton() {
        return this.from == this.to;
    }

    @Override
    public boolean contains(long value) {
        return !this.isEmpty() && value >= this.getFrom() && value <= this.getTo();
    }

    @Override
    public boolean isAdjacent(Range other) {
        return this.isEmpty() || other.isEmpty() || other instanceof InfiniteRange || this.getFrom() == other.getTo() + 1L || this.getTo() == other.getFrom() - 1L;
    }

    @Override
    public boolean intersects(Range other) {
        return this.isEmpty() || other.isEmpty() || other instanceof InfiniteRange || this.contains(other.getFrom()) || this.contains(other.getTo());
    }

    @Override
    public Range union(Range other) {
        if (this.isEmpty()) {
            return other;
        }
        if (other.isEmpty()) {
            return this;
        }
        if (other instanceof ContiguousRange) {
            if (this.intersects(other) || this.isAdjacent(other)) {
                return new ContiguousRange(Math.min(this.getFrom(), other.getFrom()), Math.max(this.getTo(), other.getTo()));
            }
            return new SparseRange(this, (ContiguousRange)other);
        }
        if (other instanceof InfiniteRange) {
            return other;
        }
        return other.union(this);
    }

    @Override
    public Range remove(long value) {
        if (this.isEmpty()) {
            return this;
        }
        if (this.getFrom() == value) {
            return new ContiguousRange(this.getFrom() + 1L, this.getTo());
        }
        if (this.getTo() == value) {
            return new ContiguousRange(this.getFrom(), this.getTo() - 1L);
        }
        if (this.contains(value)) {
            return new SparseRange(new ContiguousRange(this.getFrom(), value - 1L), new ContiguousRange(value + 1L, this.getTo()));
        }
        return this;
    }

    @Override
    public Range add(long value) {
        if (this.isEmpty()) {
            return new ContiguousRange(value, value);
        }
        if (this.contains(value)) {
            return this;
        }
        if (value == this.getFrom() - 1L) {
            return new ContiguousRange(value, this.to);
        }
        if (value == this.getTo() + 1L) {
            return new ContiguousRange(this.from, value);
        }
        return new SparseRange(this, new ContiguousRange(value, value));
    }

    @Override
    public Iterator<Long> iterator() {
        return new RangeIterator(this);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Range) {
            Range other = (Range)object;
            return this.getFrom() == other.getFrom() && this.getTo() == other.getTo() && this.size() == other.size();
        }
        return false;
    }

    @Override
    public int compareTo(Range other) {
        if (other instanceof ContiguousRange && this.equals(other) ^ !this.intersects((ContiguousRange)other)) {
            if (this.getFrom() < other.getFrom()) {
                return -1;
            }
            if (this.getFrom() > other.getFrom()) {
                return 1;
            }
            return 0;
        }
        throw new NotComparableRuntimeException();
    }

    public String toString() {
        return this.isEmpty() ? "ContiguousRange[]" : (this.isSingleton() ? String.format("ContiguousRange[%d]", this.from) : String.format("ContiguousRange[%d..%d]", this.from, this.to));
    }

    public void readExternal(DataInput in) throws IOException {
        this.from = ExternalizableHelper.readLong((DataInput)in);
        this.to = ExternalizableHelper.readLong((DataInput)in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.from);
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.to);
    }

    public void readExternal(PofReader reader) throws IOException {
        this.from = reader.readLong(0);
        this.to = reader.readLong(1);
    }

    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeLong(0, this.from);
        writer.writeLong(1, this.to);
    }

    static class RangeIterator
    implements Iterator<Long> {
        private ContiguousRange range;
        private long next;

        public RangeIterator(ContiguousRange range) {
            this.range = range;
            this.next = range.getFrom();
        }

        @Override
        public boolean hasNext() {
            return !this.range.isEmpty() && this.next <= this.range.getTo();
        }

        @Override
        public Long next() {
            return this.next++;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Can't remove values from Range implementations as they are immutable");
        }
    }
}

