/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.ranges;

import com.oracle.coherence.common.ranges.ContiguousRange;
import com.oracle.coherence.common.ranges.InfiniteRange;
import com.oracle.coherence.common.ranges.Range;
import com.oracle.coherence.common.ranges.Ranges;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.TreeSet;

public class SparseRange
implements Range,
ExternalizableLite,
PortableObject,
Iterable<Long> {
    private long m_lFrom;
    private TreeSet<ContiguousRange> m_oSubRanges;

    public SparseRange() {
        this.m_oSubRanges = new TreeSet();
    }

    SparseRange(long from) {
        this.m_lFrom = from;
        this.m_oSubRanges = new TreeSet();
    }

    private SparseRange(TreeSet<ContiguousRange> contiguousRanges) {
        assert (!contiguousRanges.isEmpty());
        this.m_oSubRanges = contiguousRanges;
        this.m_lFrom = this.m_oSubRanges.first().getFrom();
    }

    SparseRange(ContiguousRange contiguousRange1, ContiguousRange contiguousRange2) {
        if (contiguousRange1.isEmpty() && contiguousRange2.isEmpty()) {
            this.m_lFrom = Math.min(contiguousRange1.getFrom(), contiguousRange2.getFrom());
            this.m_oSubRanges = new TreeSet();
        } else if (contiguousRange1.isEmpty()) {
            this.m_lFrom = contiguousRange2.getFrom();
            this.m_oSubRanges = new TreeSet();
            this.m_oSubRanges.add(contiguousRange2);
        } else if (contiguousRange2.isEmpty()) {
            this.m_lFrom = contiguousRange1.getFrom();
            this.m_oSubRanges = new TreeSet();
            this.m_oSubRanges.add(contiguousRange1);
        } else {
            this.m_oSubRanges = new TreeSet();
            if (contiguousRange1.isAdjacent(contiguousRange2) || contiguousRange1.intersects(contiguousRange2)) {
                this.m_oSubRanges.add((ContiguousRange)contiguousRange1.union(contiguousRange2));
            } else {
                this.m_oSubRanges.add(contiguousRange1);
                this.m_oSubRanges.add(contiguousRange2);
            }
            this.m_lFrom = this.m_oSubRanges.first().getFrom();
        }
    }

    @Override
    public long getFrom() {
        return this.isEmpty() ? this.m_lFrom : this.m_oSubRanges.first().getFrom();
    }

    @Override
    public long getTo() {
        return this.isEmpty() ? this.m_lFrom - 1L : this.m_oSubRanges.last().getTo();
    }

    @Override
    public long size() {
        long size = 0L;
        for (ContiguousRange range : this.m_oSubRanges) {
            size += range.size();
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        return this.m_oSubRanges.isEmpty();
    }

    @Override
    public boolean isSingleton() {
        return this.m_oSubRanges.size() == 1 && this.m_oSubRanges.first().isSingleton();
    }

    @Override
    public boolean contains(long value) {
        for (ContiguousRange range : this.m_oSubRanges) {
            if (!range.contains(value)) continue;
            return true;
        }
        return false;
    }

    private boolean testAdjacency(Range other) {
        for (ContiguousRange range : this.m_oSubRanges) {
            if (!other.isAdjacent(range)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAdjacent(Range other) {
        return this.isEmpty() || other.isEmpty() || other instanceof InfiniteRange || this.testAdjacency(other);
    }

    @Override
    public boolean intersects(Range other) {
        return this.isEmpty() || other.isEmpty() || other instanceof InfiniteRange || this.testIntersection(other);
    }

    private boolean testIntersection(Range other) {
        if (other instanceof ContiguousRange) {
            return this.contains(other.getFrom()) || this.contains(other.getTo()) || other.contains(this.getFrom()) || other.contains(this.getTo());
        }
        if (other instanceof SparseRange) {
            for (ContiguousRange range : this.m_oSubRanges) {
                if (!other.intersects(range)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public Range add(long value) {
        return this.union(new ContiguousRange(value, value));
    }

    @Override
    public Range remove(long value) {
        TreeSet<ContiguousRange> resultingSubRanges = new TreeSet<ContiguousRange>();
        for (ContiguousRange range : this.m_oSubRanges) {
            if (range.contains(value)) {
                Range resultingRange = range.remove(value);
                if (resultingRange.isEmpty()) continue;
                if (resultingRange instanceof ContiguousRange) {
                    resultingSubRanges.add((ContiguousRange)resultingRange);
                    continue;
                }
                resultingSubRanges.add(((SparseRange)resultingRange).m_oSubRanges.first());
                resultingSubRanges.add(((SparseRange)resultingRange).m_oSubRanges.last());
                continue;
            }
            resultingSubRanges.add(range);
        }
        if (resultingSubRanges.isEmpty()) {
            return new ContiguousRange(value + 1L);
        }
        if (resultingSubRanges.size() == 1) {
            return (Range)resultingSubRanges.first();
        }
        return new SparseRange(resultingSubRanges);
    }

    @Override
    public Range union(Range other) {
        Iterator<ContiguousRange> rightSubRanges;
        if (other.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return other;
        }
        if (other instanceof InfiniteRange) {
            return other;
        }
        Iterator<ContiguousRange> leftSubRanges = this.m_oSubRanges.iterator();
        if (other instanceof ContiguousRange) {
            TreeSet<ContiguousRange> temp = new TreeSet<ContiguousRange>();
            temp.add((ContiguousRange)other);
            rightSubRanges = temp.iterator();
        } else {
            rightSubRanges = ((SparseRange)other).m_oSubRanges.iterator();
        }
        TreeSet<ContiguousRange> resultingSubRanges = new TreeSet<ContiguousRange>();
        ContiguousRange left = null;
        ContiguousRange right = null;
        ContiguousRange current = leftSubRanges.next();
        while (leftSubRanges.hasNext() || rightSubRanges.hasNext()) {
            if (left == null && leftSubRanges.hasNext()) {
                left = leftSubRanges.next();
            }
            if (right == null && rightSubRanges.hasNext()) {
                right = rightSubRanges.next();
            }
            if (left != null && (current.intersects(left) || current.isAdjacent(left))) {
                current = (ContiguousRange)current.union(left);
                left = null;
                continue;
            }
            if (right != null && (current.intersects(right) || current.isAdjacent(right))) {
                current = (ContiguousRange)current.union(right);
                right = null;
                if (left == null || !current.intersects(left) && !current.isAdjacent(left)) continue;
                current = (ContiguousRange)current.union(left);
                left = null;
                continue;
            }
            resultingSubRanges.add(current);
            if (left == null) {
                current = right;
                right = null;
                continue;
            }
            current = left;
            left = null;
        }
        if (left != null) {
            resultingSubRanges.add(left);
        }
        if (right != null) {
            resultingSubRanges.add(right);
        }
        if (current != null) {
            resultingSubRanges.add(current);
        }
        if (resultingSubRanges.isEmpty()) {
            return Ranges.EMPTY;
        }
        if (resultingSubRanges.size() == 1) {
            return (Range)resultingSubRanges.first();
        }
        return new SparseRange(resultingSubRanges);
    }

    @Override
    public Iterator<Long> iterator() {
        return new RangeIterator(this);
    }

    private boolean iterateForEquality(Range other) {
        Iterator<ContiguousRange> thisSubRanges;
        if (other instanceof ContiguousRange) {
            ContiguousRange otherrange = (ContiguousRange)other;
            thisSubRanges = this.m_oSubRanges.iterator();
            if (thisSubRanges.hasNext()) {
                Range range = thisSubRanges.next();
                if (!range.equals(otherrange)) {
                    return false;
                }
                return !thisSubRanges.hasNext();
            }
        }
        if (other instanceof SparseRange) {
            SparseRange othersparse = (SparseRange)other;
            thisSubRanges = this.m_oSubRanges.iterator();
            Iterator<ContiguousRange> otherSubRanges = othersparse.m_oSubRanges.iterator();
            while (thisSubRanges.hasNext() && otherSubRanges.hasNext()) {
                if (thisSubRanges.next().equals(otherSubRanges.next())) continue;
                return false;
            }
            return thisSubRanges.hasNext() == otherSubRanges.hasNext();
        }
        if (other instanceof InfiniteRange) {
            return false;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Range) {
            Range other = (Range)object;
            return this.iterateForEquality(other);
        }
        return false;
    }

    public String toString() {
        return this.isEmpty() ? "SparseRange[]" : String.format("SparseRange[%s]", this.m_oSubRanges);
    }

    public void readExternal(DataInput in) throws IOException {
        this.m_lFrom = ExternalizableHelper.readLong((DataInput)in);
        this.m_oSubRanges = new TreeSet();
        ExternalizableHelper.readCollection((DataInput)in, this.m_oSubRanges, (ClassLoader)this.getClass().getClassLoader());
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.m_lFrom);
        ExternalizableHelper.writeCollection((DataOutput)out, this.m_oSubRanges);
    }

    public void readExternal(PofReader reader) throws IOException {
        this.m_lFrom = reader.readLong(0);
        reader.readCollection(1, this.m_oSubRanges);
    }

    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeLong(0, this.m_lFrom);
        writer.writeCollection(1, this.m_oSubRanges);
    }

    static class RangeIterator
    implements Iterator<Long> {
        private Iterator<ContiguousRange> ranges;
        private Iterator<Long> iterator;

        RangeIterator(SparseRange sparseRange) {
            this.ranges = sparseRange.m_oSubRanges.iterator();
            this.iterator = this.ranges.hasNext() ? this.ranges.next().iterator() : null;
        }

        @Override
        public boolean hasNext() {
            return this.iterator != null && this.iterator.hasNext() || this.ranges.hasNext();
        }

        @Override
        public Long next() {
            if (!this.iterator.hasNext()) {
                this.iterator = this.ranges.next().iterator();
            }
            return this.iterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Can't remove values from Range implementations as they are immutable");
        }
    }
}

