/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.resourcing;

import com.oracle.coherence.common.resourcing.AbstractResourceProvider;
import com.oracle.coherence.common.resourcing.ResourceUnavailableException;

public abstract class AbstractDeferredResourceProvider<T>
extends AbstractResourceProvider<T> {
    private long retryDelayDurationMS;
    private long totalRetryDurationMS;

    public AbstractDeferredResourceProvider(String resourceName, long retryDelayDurationMS, long totalRetryDurationMS) {
        super(resourceName);
        this.retryDelayDurationMS = retryDelayDurationMS;
        this.totalRetryDurationMS = totalRetryDurationMS;
    }

    @Override
    public final T getResource() throws ResourceUnavailableException {
        for (long retryDuration = 0L; this.totalRetryDurationMS < 0L || retryDuration < this.totalRetryDurationMS; retryDuration += this.retryDelayDurationMS) {
            try {
                Object resource = this.ensureResource();
                if (resource != null) {
                    return resource;
                }
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                throw resourceUnavailableException;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            try {
                Thread.sleep(this.retryDelayDurationMS);
                continue;
            }
            catch (InterruptedException interruptedException) {
                throw new ResourceUnavailableException(String.format("The resource [%s] is unavailable (ensuring was interrupted).", this.getResourceName()), interruptedException);
            }
        }
        throw new ResourceUnavailableException(this.getResourceName());
    }
}

