/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.resourcing;

import com.oracle.coherence.common.resourcing.AbstractResourceProvider;
import com.oracle.coherence.common.resourcing.ResourceUnavailableException;
import com.oracle.coherence.common.resourcing.SupervisedResourceProvider;

public abstract class AbstractSupervisedResourceProvider<T>
extends AbstractResourceProvider<T>
implements SupervisedResourceProvider<T> {
    private volatile long instantOfLastFailure = 0L;
    private long minimumAccessRetryDelay;

    public AbstractSupervisedResourceProvider(String resourceName, long minimumAccessRetryDelay) {
        super(resourceName);
        this.minimumAccessRetryDelay = minimumAccessRetryDelay;
    }

    @Override
    public final T getResource() throws ResourceUnavailableException {
        if (this.isResourceAccessible()) {
            AbstractSupervisedResourceProvider abstractSupervisedResourceProvider = this;
            synchronized (abstractSupervisedResourceProvider) {
                if (this.isResourceAccessible()) {
                    try {
                        return this.ensureResource();
                    }
                    catch (ResourceUnavailableException resourceUnavailableException) {
                        this.instantOfLastFailure = System.currentTimeMillis();
                        throw resourceUnavailableException;
                    }
                    catch (RuntimeException runtimeException) {
                        this.instantOfLastFailure = System.currentTimeMillis();
                        throw runtimeException;
                    }
                }
                throw new ResourceUnavailableException(this.getResourceName());
            }
        }
        throw new ResourceUnavailableException(this.getResourceName());
    }

    @Override
    public boolean isResourceAccessible() {
        return System.currentTimeMillis() > this.instantOfLastFailure + this.minimumAccessRetryDelay;
    }

    @Override
    public void resourceNoLongerAvailable() {
        this.instantOfLastFailure = System.currentTimeMillis();
    }
}

