/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.runtime;

import com.oracle.coherence.common.runtime.Application;
import com.oracle.coherence.common.runtime.ApplicationConsole;
import com.oracle.coherence.common.runtime.SystemApplicationConsole;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import java.util.Properties;

@Deprecated
public abstract class AbstractApplication
implements Application {
    private final Process m_process;
    private String m_name;
    private final ApplicationConsole m_console;
    private Properties m_environmentVariables;
    private Thread m_thread;
    private long m_pid = -1L;

    public AbstractApplication(Process process, String name, ApplicationConsole console, Properties environmentVariables) {
        this.m_process = process;
        this.m_name = name;
        this.m_console = console == null ? new SystemApplicationConsole() : console;
        this.m_environmentVariables = environmentVariables;
        this.m_pid = this.determinePID(process);
        this.m_thread = new Thread(new Runnable(){

            @Override
            public void run() {
                long lineNumber = 1L;
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(new BufferedInputStream(AbstractApplication.this.m_process.getInputStream())));
                    while ((line = reader.readLine()) != null) {
                        AbstractApplication.this.m_console.printf("[%s%s] %4d: %s\n", AbstractApplication.this.m_name, AbstractApplication.this.m_pid < 0L ? "" : ":" + AbstractApplication.this.m_pid, lineNumber++, line);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                AbstractApplication.this.m_console.printf("[%s%s] %4d: (terminated)\n", AbstractApplication.this.m_name, AbstractApplication.this.m_pid < 0L ? "" : ":" + AbstractApplication.this.m_pid, lineNumber++);
            }
        });
        this.m_thread.setDaemon(true);
        this.m_thread.start();
    }

    @Override
    public Properties getEnvironmentVariables() {
        return this.m_environmentVariables;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public void destroy() {
        this.m_thread.interrupt();
        try {
            this.m_process.getInputStream().close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.m_process.getOutputStream().close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.m_process.getErrorStream().close();
        }
        catch (IOException e) {
            // empty catch block
        }
        this.m_process.destroy();
        try {
            this.m_process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public long getPid() {
        return this.m_pid;
    }

    private long determinePID(Process p) {
        long pid = -1L;
        try {
            if (p.getClass().getSimpleName().equals("UNIXProcess")) {
                Class<?> clazz = p.getClass();
                Field pidF = clazz.getDeclaredField("pid");
                pidF.setAccessible(true);
                Object oPid = pidF.get(p);
                if (oPid instanceof Number) {
                    pid = ((Number)oPid).longValue();
                } else if (oPid instanceof String) {
                    pid = Long.parseLong((String)oPid);
                }
            } else {
                RuntimeMXBean rtb = ManagementFactory.getRuntimeMXBean();
                String sProcess = rtb.getName();
                int iPID = sProcess.indexOf(64);
                if (iPID > 0) {
                    String sPID = sProcess.substring(0, iPID);
                    pid = Long.parseLong(sPID);
                }
            }
        }
        catch (SecurityException e) {
        }
        catch (NoSuchFieldException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
        return pid;
    }
}

