/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.runtime;

import com.oracle.coherence.common.network.AvailablePortIterator;
import com.oracle.coherence.common.runtime.AbstractApplicationSchema;
import com.oracle.coherence.common.runtime.JavaApplication;
import com.oracle.coherence.common.runtime.JavaApplicationSchema;
import com.oracle.coherence.common.runtime.PropertiesBuilder;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public abstract class AbstractJavaApplicationSchema<A extends JavaApplication, S extends JavaApplicationSchema<A, S>>
extends AbstractApplicationSchema<A, S>
implements JavaApplicationSchema<A, S> {
    public static final String SUN_MANAGEMENT_JMXREMOTE = "com.sun.management.jmxremote";
    public static final String SUN_MANAGEMENT_JMXREMOTE_PORT = "com.sun.management.jmxremote.port";
    public static final String SUN_MANAGEMENT_JMXREMOTE_AUTHENTICATE = "com.sun.management.jmxremote.authenticate";
    public static final String SUN_MANAGEMENT_JMXREMOTE_SSL = "com.sun.management.jmxremote.ssl";
    public static final String JAVA_RMI_SERVER_HOSTNAME = "java.rmi.server.hostname";
    public static final String JAVA_NET_PREFER_IPV4_STACK = "java.net.preferIPv4Stack";
    private String m_applicationClassName;
    private String m_classPath;
    private ArrayList<String> m_jvmOptions;
    private PropertiesBuilder m_systemPropertiesBuilder;

    public AbstractJavaApplicationSchema(String applicationClassName) {
        this(applicationClassName, System.getProperty("java.class.path"));
    }

    public AbstractJavaApplicationSchema(String applicationClassName, String classPath) {
        this.m_applicationClassName = applicationClassName;
        this.m_classPath = classPath;
        this.m_jvmOptions = new ArrayList();
        this.m_systemPropertiesBuilder = new PropertiesBuilder();
    }

    @Override
    public PropertiesBuilder getSystemPropertiesBuilder() {
        return this.m_systemPropertiesBuilder;
    }

    @Override
    public String getClassPath() {
        return this.m_classPath;
    }

    @Override
    public String getApplicationClassName() {
        return this.m_applicationClassName;
    }

    public S setClassPath(String classPath) {
        this.m_classPath = classPath;
        return (S)this;
    }

    public S setSystemProperty(String name, Object value) {
        this.m_systemPropertiesBuilder.setProperty(name, value);
        return (S)this;
    }

    public S setDefaultSystemProperty(String name, Object value) {
        this.m_systemPropertiesBuilder.setDefaultProperty(name, value);
        return (S)this;
    }

    public S setSystemProperties(PropertiesBuilder systemProperties) {
        this.m_systemPropertiesBuilder.addProperties(systemProperties);
        return (S)this;
    }

    public S addOption(String option) {
        this.m_jvmOptions.add(option.startsWith("-") ? option.substring(1) : option);
        return (S)this;
    }

    public S setOption(String option) {
        this.addOption(option);
        return (S)this;
    }

    @Override
    public List<String> getJVMOptions() {
        return this.m_jvmOptions;
    }

    public S setJMXSupport(boolean enabled) {
        if (enabled) {
            this.setDefaultSystemProperty(SUN_MANAGEMENT_JMXREMOTE_PORT, 9000);
            this.setDefaultSystemProperty(SUN_MANAGEMENT_JMXREMOTE, "");
            this.setDefaultSystemProperty(SUN_MANAGEMENT_JMXREMOTE_AUTHENTICATE, false);
            this.setDefaultSystemProperty(SUN_MANAGEMENT_JMXREMOTE_SSL, false);
            this.setDefaultSystemProperty(JAVA_RMI_SERVER_HOSTNAME, "localhost");
            return (S)this;
        }
        this.m_systemPropertiesBuilder.removeProperty(SUN_MANAGEMENT_JMXREMOTE);
        this.m_systemPropertiesBuilder.removeProperty(SUN_MANAGEMENT_JMXREMOTE_PORT);
        this.m_systemPropertiesBuilder.removeProperty(SUN_MANAGEMENT_JMXREMOTE_AUTHENTICATE);
        this.m_systemPropertiesBuilder.removeProperty(SUN_MANAGEMENT_JMXREMOTE_SSL);
        this.m_systemPropertiesBuilder.removeProperty(JAVA_RMI_SERVER_HOSTNAME);
        return (S)this;
    }

    public S setPreferIPv4(boolean enabled) {
        return this.setDefaultSystemProperty(JAVA_NET_PREFER_IPV4_STACK, enabled);
    }

    public S setJMXAuthentication(boolean enabled) {
        return this.setDefaultSystemProperty(SUN_MANAGEMENT_JMXREMOTE_AUTHENTICATE, enabled);
    }

    public S setJMXPort(int port) {
        return this.setSystemProperty(SUN_MANAGEMENT_JMXREMOTE_PORT, port);
    }

    public S setJMXPort(AvailablePortIterator portIterator) {
        return this.setSystemProperty(SUN_MANAGEMENT_JMXREMOTE_PORT, portIterator);
    }

    public S setRMIServerHostName(String rmiServerHostName) {
        this.setDefaultSystemProperty(JAVA_RMI_SERVER_HOSTNAME, rmiServerHostName);
        return (S)this;
    }
}

