/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.runtime;

import com.oracle.coherence.common.resourcing.AbstractDeferredResourceProvider;
import com.oracle.coherence.common.resourcing.ResourceUnavailableException;
import com.oracle.coherence.common.runtime.AbstractApplication;
import com.oracle.coherence.common.runtime.ApplicationConsole;
import com.oracle.coherence.common.runtime.JavaApplication;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Properties;
import javax.management.JMX;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

@Deprecated
public class JavaConsoleApplication
extends AbstractApplication
implements JavaApplication {
    private Properties systemProperties;
    private JMXConnector jmxConnector;
    private MBeanServerConnection mBeanServerConnection;

    public JavaConsoleApplication(Process process, String name, ApplicationConsole console, Properties environmentVariables, Properties systemProperties) {
        super(process, name, console, environmentVariables);
        this.systemProperties = systemProperties;
        this.jmxConnector = null;
        this.mBeanServerConnection = null;
    }

    @Override
    public Properties getSystemProperties() {
        return this.systemProperties;
    }

    @Override
    public String getSystemProperty(String name) {
        return this.systemProperties.getProperty(name);
    }

    public int getRemoteJMXPort() {
        if (this.systemProperties.containsKey("com.sun.management.jmxremote.port")) {
            return Integer.parseInt(this.systemProperties.getProperty("com.sun.management.jmxremote.port"));
        }
        throw new UnsupportedOperationException("Application is not enabled for remote JMX management");
    }

    public String getRMIServerHostName() {
        return this.systemProperties.getProperty("java.rmi.server.hostname");
    }

    @Override
    public MBeanServerConnection getMBeanServerConnection(long waitTimeMS) {
        if (this.mBeanServerConnection == null) {
            try {
                final String remoteJMXConnectionUrl = String.format("service:jmx:rmi:///jndi/rmi://%s:%d/jmxrmi", this.getRMIServerHostName(), this.getRemoteJMXPort());
                AbstractDeferredResourceProvider<JMXConnector> deferredJMXConnector = new AbstractDeferredResourceProvider<JMXConnector>("JMX Connector " + remoteJMXConnectionUrl, 1000L, waitTimeMS){

                    @Override
                    protected JMXConnector ensureResource() throws ResourceUnavailableException {
                        String username = "";
                        String password = "";
                        HashMap<String, String[]> env = new HashMap<String, String[]>();
                        String[] credentials = new String[]{username, password};
                        env.put("jmx.remote.credentials", credentials);
                        try {
                            JMXConnector connector = JMXConnectorFactory.newJMXConnector(new JMXServiceURL(remoteJMXConnectionUrl), env);
                            connector.connect();
                            return connector;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
                this.jmxConnector = (JMXConnector)deferredJMXConnector.getResource();
                this.mBeanServerConnection = this.jmxConnector.getMBeanServerConnection();
            }
            catch (MalformedURLException e) {
                throw new UnsupportedOperationException("Failed to connect to the JMX infrastructure for the application", e);
            }
            catch (IOException e) {
                throw new UnsupportedOperationException("Failed to communicate with the JMX infrastructure for the application", e);
            }
            catch (ResourceUnavailableException e) {
                throw new UnsupportedOperationException("Timed out trying to connect to the JMX infrastructure for the application", e);
            }
        }
        return this.mBeanServerConnection;
    }

    @Override
    public MBeanServerConnection getMBeanServerConnection() {
        return this.getMBeanServerConnection(60000L);
    }

    @Override
    public <T> T getMBeanProxy(ObjectName objectName, Class<T> clazz) {
        return JMX.newMBeanProxy(this.getMBeanServerConnection(), objectName, clazz);
    }

    @Override
    public MBeanInfo getMBeanInfo(final ObjectName objectName, long waitTimeMS) {
        try {
            AbstractDeferredResourceProvider<MBeanInfo> mBeanInfoProvider = new AbstractDeferredResourceProvider<MBeanInfo>(objectName.toString(), 200L, waitTimeMS){

                @Override
                protected MBeanInfo ensureResource() throws ResourceUnavailableException {
                    try {
                        return JavaConsoleApplication.this.getMBeanServerConnection().getMBeanInfo(objectName);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            return (MBeanInfo)mBeanInfoProvider.getResource();
        }
        catch (ResourceUnavailableException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Failed to retrieve specified MBean [" + objectName + "]", e);
        }
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName objectName) {
        return this.getMBeanInfo(objectName, 60000L);
    }

    @Override
    public void destroy() {
        if (this.jmxConnector != null) {
            try {
                this.mBeanServerConnection = null;
                this.jmxConnector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.destroy();
    }
}

