/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.runtime;

import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

@Deprecated
public class PropertiesBuilder {
    private LinkedHashMap<String, Property> m_properties = new LinkedHashMap();

    public PropertiesBuilder() {
    }

    public PropertiesBuilder(Map<String, String> properties) {
        this();
        for (String name : properties.keySet()) {
            this.m_properties.put(name, new Property(name, null, properties.get(name)));
        }
    }

    public PropertiesBuilder(Properties properties) {
        this();
        for (String key : properties.stringPropertyNames()) {
            this.m_properties.put(key, new Property(key, null, properties.getProperty(key)));
        }
    }

    public PropertiesBuilder(PropertiesBuilder propertiesBuilder) {
        this();
        for (String name : propertiesBuilder.getPropertyNames()) {
            this.m_properties.put(name, new Property(propertiesBuilder.m_properties.get(name)));
        }
    }

    public PropertiesBuilder setProperty(String name, Iterator<?> iterator) {
        if (this.containsProperty(name)) {
            this.m_properties.get(name).setValue(iterator);
        } else {
            this.m_properties.put(name, new Property(name, iterator, null));
        }
        return this;
    }

    public PropertiesBuilder setDefaultProperty(String name, Iterator<?> defaultIterator) {
        if (this.containsProperty(name)) {
            this.m_properties.get(name).setDefaultValue(defaultIterator);
        } else {
            this.m_properties.put(name, new Property(name, null, defaultIterator));
        }
        return this;
    }

    public PropertiesBuilder setProperty(String name, Object value) {
        if (this.containsProperty(name)) {
            this.m_properties.get(name).setValue(value);
        } else {
            this.m_properties.put(name, new Property(name, value, null));
        }
        return this;
    }

    public PropertiesBuilder setDefaultProperty(String name, Object defaultValue) {
        if (this.containsProperty(name)) {
            this.m_properties.get(name).setDefaultValue(defaultValue);
        } else {
            this.m_properties.put(name, new Property(name, null, defaultValue));
        }
        return this;
    }

    public void setProperties(PropertiesBuilder propertiesBuilder) {
        this.m_properties.putAll(propertiesBuilder.m_properties);
    }

    public PropertiesBuilder addProperties(PropertiesBuilder propertiesBuilder) {
        this.setProperties(propertiesBuilder);
        return this;
    }

    public boolean containsProperty(String name) {
        return this.m_properties.containsKey(name);
    }

    public Object getProperty(String name) {
        if (this.m_properties.containsKey(name)) {
            Property property = this.m_properties.get(name);
            return property.hasValue() ? property.getValue() : property.getDefaultValue();
        }
        return null;
    }

    public void removeProperty(String name) {
        this.m_properties.remove(name);
    }

    public void clear() {
        this.m_properties.clear();
    }

    public Iterable<String> getPropertyNames() {
        return this.m_properties.keySet();
    }

    public Properties realize(PropertiesBuilder overrides) {
        Properties result = new Properties();
        if (overrides != null) {
            result.putAll((Map<?, ?>)overrides.realize());
        }
        for (String name : this.getPropertyNames()) {
            Object value;
            if (result.containsKey(name) || (value = this.getProperty(name)) == null) continue;
            if (value instanceof Iterator) {
                Iterator iterator = (Iterator)value;
                if (iterator.hasNext()) {
                    result.put(name, iterator.next().toString());
                    continue;
                }
                throw new IndexOutOfBoundsException(String.format("No more values available for the property [%s]", name));
            }
            result.put(name, value.toString());
        }
        return result;
    }

    public Properties realize() {
        return this.realize(null);
    }

    public static PropertiesBuilder fromPropertiesFile(String fileName) throws IOException {
        Properties properties = new Properties();
        URL url = ClassLoader.getSystemResource(fileName);
        properties.load(url.openStream());
        return new PropertiesBuilder(properties);
    }

    public static PropertiesBuilder fromCurrentEnvironmentVariables() {
        return new PropertiesBuilder(System.getenv());
    }

    public static PropertiesBuilder fromCurrentSystemProperties() {
        return new PropertiesBuilder(System.getProperties());
    }

    private static class Property {
        private String name;
        private Object value;
        private Object defaultValue;

        public Property(Property property) {
            this.name = property.getName();
            this.value = property.getValue();
            this.defaultValue = property.getDefaultValue();
        }

        public Property(String name, Object value, Object defaultValue) {
            this.name = name;
            this.value = value;
            this.defaultValue = defaultValue;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public boolean hasValue() {
            return this.value != null;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
        }

        public String toString() {
            return String.format("{name=%s, value=%s, defaultValue=%s}", this.name, this.value, this.defaultValue);
        }
    }
}

