/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.sequencegenerators;

import com.oracle.coherence.common.ranges.Range;
import com.oracle.coherence.common.ranges.Ranges;
import com.oracle.coherence.common.sequencegenerators.SequenceGenerator;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.processor.AbstractProcessor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ClusteredSequenceGenerator
implements SequenceGenerator {
    private String sequenceName;
    private long initialValue;

    public ClusteredSequenceGenerator(String sequenceName, long initialValue) {
        this.sequenceName = sequenceName;
        this.initialValue = initialValue;
    }

    @Override
    public long next() {
        return this.next(1L).getFrom();
    }

    @Override
    public Range next(long sequenceSize) {
        NamedCache namedCache = CacheFactory.getCache((String)"coherence.common.sequencegenerators");
        long from = (Long)namedCache.invoke((Object)this.sequenceName, (InvocableMap.EntryProcessor)new GenerateSequenceNumberProcessor(this.initialValue, sequenceSize));
        return Ranges.newRange(from, from + sequenceSize - 1L);
    }

    public static class State
    implements ExternalizableLite,
    PortableObject {
        public static final String CACHENAME = "coherence.common.sequencegenerators";
        private long nextValue;

        public State() {
        }

        public State(long initialValue) {
            this.nextValue = initialValue;
        }

        public long generate(long sequenceSize) {
            long start = this.nextValue;
            this.nextValue += sequenceSize;
            return start;
        }

        public void readExternal(DataInput in) throws IOException {
            this.nextValue = ExternalizableHelper.readLong((DataInput)in);
        }

        public void writeExternal(DataOutput out) throws IOException {
            ExternalizableHelper.writeLong((DataOutput)out, (long)this.nextValue);
        }

        public void readExternal(PofReader reader) throws IOException {
            this.nextValue = reader.readLong(0);
        }

        public void writeExternal(PofWriter writer) throws IOException {
            writer.writeLong(0, this.nextValue);
        }

        public String toString() {
            return String.format("ClusteredSequenceGenerator.State{nextValue=%d}", this.nextValue);
        }
    }

    public static class GenerateSequenceNumberProcessor
    extends AbstractProcessor
    implements ExternalizableLite,
    PortableObject {
        private long sequenceSize;
        private long initialValue;

        public GenerateSequenceNumberProcessor() {
            this.sequenceSize = 1L;
            this.initialValue = 1L;
        }

        public GenerateSequenceNumberProcessor(long initialValue, long sequenceSize) {
            this.initialValue = initialValue;
            this.sequenceSize = sequenceSize;
        }

        public Object process(InvocableMap.Entry entry) {
            State state = entry.isPresent() ? (State)entry.getValue() : new State(this.initialValue);
            long value = state.generate(this.sequenceSize);
            entry.setValue((Object)state);
            return value;
        }

        public void readExternal(DataInput in) throws IOException {
            this.initialValue = ExternalizableHelper.readLong((DataInput)in);
            this.sequenceSize = ExternalizableHelper.readLong((DataInput)in);
        }

        public void writeExternal(DataOutput out) throws IOException {
            ExternalizableHelper.writeLong((DataOutput)out, (long)this.initialValue);
            ExternalizableHelper.writeLong((DataOutput)out, (long)this.sequenceSize);
        }

        public void readExternal(PofReader reader) throws IOException {
            this.initialValue = reader.readLong(0);
            this.sequenceSize = reader.readLong(1);
        }

        public void writeExternal(PofWriter writer) throws IOException {
            writer.writeLong(0, this.initialValue);
            writer.writeLong(1, this.sequenceSize);
        }
    }
}

