/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.serialization;

import com.oracle.coherence.common.serialization.FieldSerializationProvider;
import com.oracle.coherence.common.serialization.FieldSerializer;
import com.oracle.coherence.common.serialization.fieldserializers.BigDecimalFieldSerializer;
import com.oracle.coherence.common.serialization.fieldserializers.BigIntegerFieldSerializer;
import com.oracle.coherence.common.serialization.fieldserializers.BinaryFieldSerializer;
import com.oracle.coherence.common.serialization.fieldserializers.BooleanArrayFieldSerializer;
import com.oracle.coherence.common.serialization.fieldserializers.BooleanFieldSerializer;
import com.oracle.coherence.common.serialization.fieldserializers.ByteArrayFieldSerializer;
import com.oracle.coherence.common.serialization.fieldserializers.ByteFieldSerializer;
import com.oracle.coherence.common.serialization.fieldserializers.CharacterArrayFieldSerializer;
import com.oracle.coherence.common.serialization.fieldserializers.CharacterFieldSerializer;
import com.oracle.coherence.common.serialization.fieldserializers.CollectionFieldSerializer;
import com.oracle.coherence.common.serialization.fieldserializers.DateFieldSerializer;
import com.oracle.coherence.common.serialization.fieldserializers.DoubleArrayFieldSerializer;
import com.oracle.coherence.common.serialization.fieldserializers.DoubleFieldSerializer;
import com.oracle.coherence.common.serialization.fieldserializers.FloatArrayFieldSerializer;
import com.oracle.coherence.common.serialization.fieldserializers.FloatFieldSerializer;
import com.oracle.coherence.common.serialization.fieldserializers.IntegerArrayFieldSerializer;
import com.oracle.coherence.common.serialization.fieldserializers.IntegerFieldSerializer;
import com.oracle.coherence.common.serialization.fieldserializers.LongArrayFieldSerializer;
import com.oracle.coherence.common.serialization.fieldserializers.LongFieldSerializer;
import com.oracle.coherence.common.serialization.fieldserializers.MapFieldSerializer;
import com.oracle.coherence.common.serialization.fieldserializers.ObjectArrayFieldSerializer;
import com.oracle.coherence.common.serialization.fieldserializers.ObjectFieldSerializer;
import com.oracle.coherence.common.serialization.fieldserializers.RawQuadFieldSerializer;
import com.oracle.coherence.common.serialization.fieldserializers.ShortArrayFieldSerializer;
import com.oracle.coherence.common.serialization.fieldserializers.ShortFieldSerializer;
import com.oracle.coherence.common.serialization.fieldserializers.StringFieldSerializer;
import com.tangosol.io.pof.RawQuad;
import com.tangosol.util.Binary;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.util.Collection;
import java.util.Map;

public class DefaultFieldSerializationProvider
implements FieldSerializationProvider {
    private final BigDecimalFieldSerializer bigDecimalFieldSerializer;
    private final BigIntegerFieldSerializer bigIntFieldSerializer;
    private final BinaryFieldSerializer binaryFieldSerializer;
    private final BooleanArrayFieldSerializer booleanArrayFieldSerializer;
    private final BooleanFieldSerializer booleanFieldSerializer;
    private final ByteArrayFieldSerializer byteArrayFieldSerializer;
    private final ByteFieldSerializer byteFieldSerializer;
    private final CharacterArrayFieldSerializer charArrayFieldSerializer;
    private final CharacterFieldSerializer charFieldSerializer;
    private final DateFieldSerializer dateFieldSerializer;
    private final DoubleArrayFieldSerializer doubleArrayFieldSerializer;
    private final DoubleFieldSerializer doubleFieldSerializer;
    private final FloatArrayFieldSerializer floatArrayFieldSerializer;
    private final FloatFieldSerializer floatFieldSerializer;
    private final IntegerArrayFieldSerializer intArrayFieldSerializer;
    private final IntegerFieldSerializer intFieldSerializer = new IntegerFieldSerializer();
    private final LongArrayFieldSerializer longArrayFieldSerializer;
    private final LongFieldSerializer longFieldSerializer;
    private final ObjectFieldSerializer objectFieldSerializer;
    private final RawQuadFieldSerializer rawQuadFieldSerializer;
    private final ShortArrayFieldSerializer shortArrayFieldSerializer;
    private final ShortFieldSerializer shortFieldSerializer;
    private final StringFieldSerializer stringFieldSerializer = new StringFieldSerializer();

    public DefaultFieldSerializationProvider() {
        this.longFieldSerializer = new LongFieldSerializer();
        this.byteFieldSerializer = new ByteFieldSerializer();
        this.charFieldSerializer = new CharacterFieldSerializer();
        this.shortFieldSerializer = new ShortFieldSerializer();
        this.booleanFieldSerializer = new BooleanFieldSerializer();
        this.doubleFieldSerializer = new DoubleFieldSerializer();
        this.floatFieldSerializer = new FloatFieldSerializer();
        this.intArrayFieldSerializer = new IntegerArrayFieldSerializer();
        this.longArrayFieldSerializer = new LongArrayFieldSerializer();
        this.byteArrayFieldSerializer = new ByteArrayFieldSerializer();
        this.charArrayFieldSerializer = new CharacterArrayFieldSerializer();
        this.shortArrayFieldSerializer = new ShortArrayFieldSerializer();
        this.booleanArrayFieldSerializer = new BooleanArrayFieldSerializer();
        this.doubleArrayFieldSerializer = new DoubleArrayFieldSerializer();
        this.floatArrayFieldSerializer = new FloatArrayFieldSerializer();
        this.bigIntFieldSerializer = new BigIntegerFieldSerializer();
        this.bigDecimalFieldSerializer = new BigDecimalFieldSerializer();
        this.rawQuadFieldSerializer = new RawQuadFieldSerializer();
        this.dateFieldSerializer = new DateFieldSerializer();
        this.binaryFieldSerializer = new BinaryFieldSerializer();
        this.objectFieldSerializer = new ObjectFieldSerializer();
    }

    @Override
    public FieldSerializer getFieldSerializer(Field field, Class<?> preferredType) {
        Class<?> fieldType = field.getType();
        if (Integer.TYPE.isAssignableFrom(fieldType)) {
            return this.intFieldSerializer;
        }
        if (String.class.isAssignableFrom(fieldType)) {
            return this.stringFieldSerializer;
        }
        if (Long.TYPE.isAssignableFrom(fieldType)) {
            return this.longFieldSerializer;
        }
        if (Byte.TYPE.isAssignableFrom(fieldType)) {
            return this.byteFieldSerializer;
        }
        if (Character.TYPE.isAssignableFrom(fieldType)) {
            return this.charFieldSerializer;
        }
        if (Short.TYPE.isAssignableFrom(fieldType)) {
            return this.shortFieldSerializer;
        }
        if (Boolean.TYPE.isAssignableFrom(fieldType)) {
            return this.booleanFieldSerializer;
        }
        if (Double.TYPE.isAssignableFrom(fieldType)) {
            return this.doubleFieldSerializer;
        }
        if (Float.TYPE.isAssignableFrom(fieldType)) {
            return this.floatFieldSerializer;
        }
        if (fieldType.isArray()) {
            Class<?> componentType = fieldType.getComponentType();
            if (Integer.TYPE.isAssignableFrom(componentType)) {
                return this.intArrayFieldSerializer;
            }
            if (Long.TYPE.isAssignableFrom(componentType)) {
                return this.longArrayFieldSerializer;
            }
            if (Byte.TYPE.isAssignableFrom(componentType)) {
                return this.byteArrayFieldSerializer;
            }
            if (Character.TYPE.isAssignableFrom(componentType)) {
                return this.charArrayFieldSerializer;
            }
            if (Short.TYPE.isAssignableFrom(componentType)) {
                return this.shortArrayFieldSerializer;
            }
            if (Boolean.TYPE.isAssignableFrom(componentType)) {
                return this.booleanArrayFieldSerializer;
            }
            if (Double.TYPE.isAssignableFrom(componentType)) {
                return this.doubleArrayFieldSerializer;
            }
            if (Float.TYPE.isAssignableFrom(componentType)) {
                return this.floatArrayFieldSerializer;
            }
            return new ObjectArrayFieldSerializer(componentType);
        }
        if (Map.class.isAssignableFrom(fieldType)) {
            return new MapFieldSerializer(field, preferredType);
        }
        if (Collection.class.isAssignableFrom(fieldType)) {
            return new CollectionFieldSerializer(field, preferredType);
        }
        if (Binary.class.isAssignableFrom(fieldType)) {
            return this.binaryFieldSerializer;
        }
        if (BigInteger.class.isAssignableFrom(fieldType)) {
            return this.bigIntFieldSerializer;
        }
        if (BigDecimal.class.isAssignableFrom(fieldType)) {
            return this.bigDecimalFieldSerializer;
        }
        if (RawQuad.class.isAssignableFrom(fieldType)) {
            return this.rawQuadFieldSerializer;
        }
        if (Date.class.isAssignableFrom(fieldType)) {
            return this.dateFieldSerializer;
        }
        return this.objectFieldSerializer;
    }
}

