/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.serialization;

import com.oracle.coherence.common.serialization.DefaultReflectedSerializer;
import com.oracle.coherence.common.serialization.FieldSerializationProvider;
import com.oracle.coherence.common.serialization.ReflectedContext;
import com.oracle.coherence.common.serialization.ReflectedSerializer;
import com.tangosol.io.pof.PofContext;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DefaultReflectedPofSerializer
implements ReflectedContext {
    private FieldSerializationProvider serializationProvider;
    private Map<Integer, ReflectedSerializer> pofSerializersByUserTypeId;
    private Map<Class<?>, Integer> pofUserTypeIdsByClass;
    private Map<String, Integer> pofUserTypeIdsByClassName;
    private ConcurrentMap<Class<?>, ReflectedSerializer> typeSerializerMap;

    public DefaultReflectedPofSerializer(FieldSerializationProvider serializationProvider) {
        this.serializationProvider = serializationProvider;
        this.typeSerializerMap = new ConcurrentHashMap(100, 0.75f, Runtime.getRuntime().availableProcessors());
        this.pofSerializersByUserTypeId = new HashMap<Integer, ReflectedSerializer>();
        this.pofUserTypeIdsByClass = new HashMap();
        this.pofUserTypeIdsByClassName = new HashMap<String, Integer>();
    }

    @Override
    public Class<?> getClass(int userTypeId) {
        ReflectedSerializer serializer = this.pofSerializersByUserTypeId.get(userTypeId);
        if (serializer != null) {
            return serializer.getType();
        }
        throw new IllegalArgumentException(String.format("Unknown User Type Id: %d", userTypeId));
    }

    @Override
    public String getClassName(int userTypeId) {
        ReflectedSerializer serializer = this.pofSerializersByUserTypeId.get(userTypeId);
        if (serializer != null) {
            return serializer.getType().getName();
        }
        throw new IllegalArgumentException(String.format("Unknown User Type Id: %d", userTypeId));
    }

    @Override
    public ReflectedSerializer getPofSerializer(int userTypeId) {
        ReflectedSerializer serializer = this.pofSerializersByUserTypeId.get(userTypeId);
        if (serializer != null) {
            return serializer;
        }
        throw new IllegalArgumentException(String.format("Unknown User Type Id: %d", userTypeId));
    }

    @Override
    public int getUserTypeIdentifier(Class<?> type) {
        Integer id = this.pofUserTypeIdsByClass.get(type);
        if (id != null) {
            return id;
        }
        throw new IllegalArgumentException(String.format("Unknown User Type: %s", type));
    }

    @Override
    public int getUserTypeIdentifier(Object object) {
        return this.getUserTypeIdentifier(object.getClass());
    }

    @Override
    public int getUserTypeIdentifier(String className) {
        Integer id = this.pofUserTypeIdsByClassName.get(className);
        if (id != null) {
            return id;
        }
        throw new IllegalArgumentException(String.format("Unknown User Type: %s", className));
    }

    @Override
    public boolean isUserType(Class<?> type) {
        return this.pofUserTypeIdsByClass.containsKey(type);
    }

    @Override
    public boolean isUserType(Object object) {
        return this.isUserType(object.getClass());
    }

    @Override
    public boolean isUserType(String className) {
        return this.pofUserTypeIdsByClassName.containsKey(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReflectedSerializer ensurePofSerializer(Class<?> type, PofContext pofContext) {
        ReflectedSerializer serializer = (ReflectedSerializer)this.typeSerializerMap.get(type);
        if (serializer == null) {
            serializer = new DefaultReflectedSerializer(type, this, pofContext);
            int id = ((DefaultReflectedSerializer)serializer).getUserTypeId();
            if (this.typeSerializerMap.putIfAbsent(type, serializer) == null) {
                this.pofSerializersByUserTypeId.put(id, serializer);
                this.pofUserTypeIdsByClass.put(type, id);
                this.pofUserTypeIdsByClassName.put(type.getName(), id);
                DefaultReflectedPofSerializer defaultReflectedPofSerializer = this;
                synchronized (defaultReflectedPofSerializer) {
                }
            }
        }
        return serializer;
    }

    @Override
    public FieldSerializationProvider getFieldSerializationProvider() {
        return this.serializationProvider;
    }

    @Override
    public ReflectedSerializer getTypeSerializer(Class<?> clazz) {
        return (ReflectedSerializer)this.typeSerializerMap.get(clazz);
    }
}

