/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.serialization;

import com.oracle.coherence.common.logging.Logger;
import com.oracle.coherence.common.serialization.FieldSerializationProvider;
import com.oracle.coherence.common.serialization.FieldSerializer;
import com.oracle.coherence.common.serialization.PofRemainder;
import com.oracle.coherence.common.serialization.ReflectedContext;
import com.oracle.coherence.common.serialization.ReflectedSerializer;
import com.oracle.coherence.common.serialization.annotations.PofField;
import com.oracle.coherence.common.serialization.annotations.PofIgnore;
import com.oracle.coherence.common.serialization.annotations.PofType;
import com.tangosol.io.pof.PofContext;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

final class DefaultReflectedSerializer
implements ReflectedSerializer {
    private static final Class<?>[] DEFAULT_PARAMETER_TYPES = new Class[0];
    private Class<?> type;
    private int userTypeId;
    private int version;
    private int detectedVersion;
    private Field remainderField;
    private Map<Integer, FieldMetaInfo[]> fieldMetaInfoByVersion;
    private ReflectedContext reflectedPofSerializer;
    private boolean implementsPortableObject = false;

    protected DefaultReflectedSerializer(Class<?> type, ReflectedContext reflectedPofContext, PofContext pofContext) {
        PofType pofType;
        this.type = type;
        this.reflectedPofSerializer = reflectedPofContext;
        this.implementsPortableObject = false;
        for (Class<?> iface : type.getInterfaces()) {
            if (!iface.equals(PortableObject.class)) continue;
            this.implementsPortableObject = true;
            break;
        }
        if (type.getSuperclass().getAnnotation(PofType.class) != null) {
            reflectedPofContext.ensurePofSerializer(type.getSuperclass(), pofContext);
        }
        int n = this.userTypeId = (pofType = type.getAnnotation(PofType.class)) == null ? pofContext.getUserTypeIdentifier(type) : pofType.id();
        if (!this.implementsPortableObject) {
            this.fieldMetaInfoByVersion = new HashMap<Integer, FieldMetaInfo[]>();
            this.detectedVersion = pofType == null ? 0 : pofType.version();
            this.setVersion(this.detectedVersion);
            this.scanFields(reflectedPofContext.getFieldSerializationProvider(), this.detectedVersion);
        }
    }

    private void scanFields(FieldSerializationProvider fieldSerializer, int version) {
        Field[] alphabeticalFields = this.type.getDeclaredFields();
        Arrays.sort(alphabeticalFields, new Comparator<Field>(){

            @Override
            public int compare(Field field1, Field field2) {
                PofField pofField1 = field1.getAnnotation(PofField.class);
                String fieldName1 = pofField1 == null ? field1.getName() : (pofField1.name().isEmpty() ? field1.getName() : pofField1.name());
                PofField pofField2 = field2.getAnnotation(PofField.class);
                String fieldName2 = pofField2 == null ? field2.getName() : (pofField2.name().isEmpty() ? field2.getName() : pofField2.name());
                return fieldName1.compareTo(fieldName2);
            }
        });
        int nextPofIndex = 1;
        ArrayList<FieldMetaInfo> fieldMetaInfos = new ArrayList<FieldMetaInfo>();
        for (int iSince = 0; iSince <= version; ++iSince) {
            for (Field field : alphabeticalFields) {
                if (field.getType().equals(PofRemainder.class)) {
                    this.remainderField = field;
                    this.remainderField.setAccessible(true);
                    continue;
                }
                if (!this.includeField(field, iSince)) continue;
                PofField annotation = field.getAnnotation(PofField.class);
                Class<?> preferredType = annotation == null ? field.getType() : annotation.type();
                String preferredName = annotation == null ? field.getName() : annotation.name();
                FieldSerializer serializer = fieldSerializer.getFieldSerializer(field, preferredType);
                FieldMetaInfo fieldMetaInfo = new FieldMetaInfo(field, nextPofIndex++, preferredName, preferredType, iSince, serializer);
                field.setAccessible(true);
                fieldMetaInfos.add(fieldMetaInfo);
            }
            this.fieldMetaInfoByVersion.put(iSince, fieldMetaInfos.toArray(new FieldMetaInfo[0]));
        }
    }

    private boolean includeField(Field field, int iSince) {
        PofField annotation = field.getAnnotation(PofField.class);
        return (field.getModifiers() & 0x98) == 0 && field.getAnnotation(PofIgnore.class) == null && (annotation == null && iSince == 0 || annotation != null && annotation.since() == iSince);
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    public int getUserTypeId() {
        return this.userTypeId;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(int version) {
        this.version = version;
        if (version > this.version) {
            this.detectedVersion = version;
            this.scanFields(this.reflectedPofSerializer.getFieldSerializationProvider(), version);
        }
    }

    public void resetVersion() {
        this.version = this.detectedVersion;
    }

    public int getDetectedVersion() {
        return this.detectedVersion;
    }

    @Override
    public Object deserialize(PofReader reader) throws IOException {
        try {
            Object instance = this.getType().getConstructor(DEFAULT_PARAMETER_TYPES).newInstance(new Object[0]);
            if (this.implementsPortableObject) {
                ((PortableObject)instance).readExternal(reader);
            } else {
                this.deserializeInto(reader, instance);
                this.readRemainder(reader, instance);
            }
            return instance;
        }
        catch (IllegalArgumentException e) {
            throw Base.ensureRuntimeException((Throwable)e);
        }
        catch (SecurityException e) {
            throw Base.ensureRuntimeException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw Base.ensureRuntimeException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw Base.ensureRuntimeException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw Base.ensureRuntimeException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw Base.ensureRuntimeException((Throwable)e);
        }
    }

    public void deserializeInto(PofReader reader, Object object) throws IllegalArgumentException, IllegalAccessException, IOException, SecurityException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        if (this.type.getSuperclass().getAnnotation(PofType.class) != null) {
            DefaultReflectedSerializer pofSerializer = (DefaultReflectedSerializer)this.reflectedPofSerializer.getPofSerializer(this.reflectedPofSerializer.getUserTypeIdentifier(this.type.getSuperclass()));
            PofReader nestedPofReader = reader.createNestedPofReader(0);
            pofSerializer.deserializeInto(nestedPofReader, object);
            pofSerializer.readRemainder(nestedPofReader, object);
        }
        for (FieldMetaInfo fieldMetaInfo : this.fieldMetaInfoByVersion.get(Math.min(this.version, reader.getVersionId()))) {
            fieldMetaInfo.getFieldSerializer().readField(object, fieldMetaInfo.getField(), reader, fieldMetaInfo.getPofIndex());
        }
    }

    @Override
    public void serialize(PofWriter writer, Object object) throws IOException {
        if (this.implementsPortableObject) {
            ((PortableObject)object).writeExternal(writer);
        } else {
            int serializingVersion = 0;
            if (this.remainderField == null) {
                serializingVersion = this.version;
            } else {
                try {
                    PofRemainder pofRemainder = (PofRemainder)this.remainderField.get(object);
                    serializingVersion = pofRemainder == null ? this.version : pofRemainder.getFromVersion();
                }
                catch (IllegalArgumentException e) {
                    Base.ensureRuntimeException((Throwable)e, (String)"While attempting to setVersionId() on the PofWriter");
                }
                catch (IllegalAccessException e) {
                    Base.ensureRuntimeException((Throwable)e, (String)"While attempting to setVersionId() on the PofWriter");
                }
            }
            writer.setVersionId(serializingVersion);
            if (this.type.getSuperclass().getAnnotation(PofType.class) != null) {
                DefaultReflectedSerializer pofSerializer = (DefaultReflectedSerializer)this.reflectedPofSerializer.getPofSerializer(this.reflectedPofSerializer.getUserTypeIdentifier(this.type.getSuperclass()));
                PofWriter nestedPofWriter = writer.createNestedPofWriter(0);
                pofSerializer.serialize(nestedPofWriter, object);
            }
            for (FieldMetaInfo fieldMetaInfo : this.fieldMetaInfoByVersion.get(serializingVersion)) {
                try {
                    fieldMetaInfo.getFieldSerializer().writeField(object, fieldMetaInfo.getField(), writer, fieldMetaInfo.getPofIndex());
                }
                catch (Exception e) {
                    Logger.log(1, "Failure assigning field %s: %s", fieldMetaInfo.getName(), e.getMessage());
                    throw new IllegalStateException(e);
                }
            }
        }
        this.writeRemainder(writer, object);
    }

    private void readRemainder(PofReader reader, Object object) throws IOException {
        if (this.remainderField == null) {
            reader.readRemainder();
        } else {
            try {
                Binary remainder = reader.readRemainder();
                PofRemainder pofRemainder = remainder == null ? null : new PofRemainder(reader.getVersionId(), remainder);
                this.remainderField.set(object, pofRemainder);
            }
            catch (IllegalArgumentException e) {
                Base.ensureRuntimeException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                Base.ensureRuntimeException((Throwable)e);
            }
        }
    }

    private void writeRemainder(PofWriter writer, Object object) throws IOException {
        if (this.remainderField == null || writer.getVersionId() < this.getDetectedVersion()) {
            writer.writeRemainder(null);
        } else {
            try {
                Binary binary;
                PofRemainder pofRemainder = (PofRemainder)this.remainderField.get(object);
                if (pofRemainder == null) {
                    binary = null;
                } else if (pofRemainder.getBinary() == null) {
                    binary = new Binary();
                    this.remainderField.set(object, binary);
                } else {
                    binary = pofRemainder.getBinary();
                }
                writer.writeRemainder(binary);
            }
            catch (IllegalArgumentException e) {
                Base.ensureRuntimeException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                Base.ensureRuntimeException((Throwable)e);
            }
        }
    }

    final class FieldMetaInfo {
        private Field field;
        private int pofIndex;
        private String name;
        private int sinceVersion;
        private Class<?> type;
        private FieldSerializer fieldSerializer;

        public FieldMetaInfo(Field field, int pofIndex, String name, Class<?> type, int sinceVersion, FieldSerializer fieldSerializer) {
            this.field = field;
            this.pofIndex = pofIndex;
            this.name = name;
            this.sinceVersion = sinceVersion;
            this.type = type;
            this.fieldSerializer = fieldSerializer;
        }

        public Field getField() {
            return this.field;
        }

        public int getPofIndex() {
            return this.pofIndex;
        }

        public String getName() {
            return this.name;
        }

        public int getSinceVersion() {
            return this.sinceVersion;
        }

        public Class<?> getType() {
            return this.type;
        }

        public FieldSerializer getFieldSerializer() {
            return this.fieldSerializer;
        }
    }
}

