/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.serialization;

import com.oracle.coherence.common.logging.Logger;
import com.oracle.coherence.common.serialization.DefaultFieldSerializationProvider;
import com.oracle.coherence.common.serialization.DefaultReflectedPofSerializer;
import com.oracle.coherence.common.serialization.FieldSerializationProvider;
import com.oracle.coherence.common.serialization.ReflectedContext;
import com.oracle.coherence.common.serialization.ReflectedSerializer;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofSerializer;
import com.tangosol.io.pof.PofWriter;
import java.io.IOException;

public class ReflectiveSerializer
implements PofSerializer {
    static final FieldSerializationProvider serializationProvider = new DefaultFieldSerializationProvider();
    static final ReflectedContext pofContext = new DefaultReflectedPofSerializer(serializationProvider);

    public Object deserialize(PofReader reader) throws IOException {
        int userTypeId = reader.getUserTypeId();
        ReflectedSerializer serializer = this.getReflectedPofContext().ensurePofSerializer(reader.getPofContext().getClass(userTypeId), reader.getPofContext());
        if (serializer == null) {
            Logger.log(1, "Unknown type (%s)", userTypeId);
            throw new IllegalStateException("Unknown type: " + userTypeId);
        }
        try {
            return serializer.deserialize(reader);
        }
        catch (Exception e) {
            Logger.log(1, "Failure during serialization of %s: %s", serializer.getType().getName(), e.getMessage());
            throw new IllegalStateException(e);
        }
    }

    public void serialize(PofWriter writer, Object object) throws IOException {
        int userTypeId = writer.getUserTypeId();
        ReflectedSerializer serializer = this.getReflectedPofContext().ensurePofSerializer(writer.getPofContext().getClass(userTypeId), writer.getPofContext());
        if (serializer == null) {
            Logger.log(1, "Unknown type (%d)", userTypeId);
            throw new IllegalStateException("Unknown type: " + userTypeId);
        }
        try {
            serializer.serialize(writer, object);
        }
        catch (Exception e) {
            Logger.log(1, "Failure during serialization of %s: %s", serializer.getType().getName(), e.getMessage());
            throw new IllegalStateException(e);
        }
    }

    public FieldSerializationProvider getFieldSerializationProvider() {
        return serializationProvider;
    }

    public ReflectedContext getReflectedPofContext() {
        return pofContext;
    }
}

