/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.serialization.fieldserializers;

import com.oracle.coherence.common.logging.Logger;
import com.oracle.coherence.common.serialization.FieldSerializer;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;

public abstract class AbstractGenericFieldSerializer
implements FieldSerializer {
    private static final Class<?>[] DEFAULT_PARAMETER_TYPES = new Class[0];
    protected Constructor<? extends Object> constructor;
    protected Type[] typeArguments;

    protected AbstractGenericFieldSerializer(Field field, Class<?> preferredType) {
        if (field.getGenericType() instanceof ParameterizedType) {
            this.typeArguments = ((ParameterizedType)field.getGenericType()).getActualTypeArguments();
            for (int i = 0; i < this.typeArguments.length; ++i) {
                Class<?> concreteClass = this.getConcreteClass(this.typeArguments[i]);
                if (concreteClass == null) {
                    this.typeArguments = null;
                    break;
                }
                this.typeArguments[i] = concreteClass;
            }
        }
        Class<?> declaredType = field.getType();
        try {
            this.constructor = preferredType.isInterface() || preferredType.isAssignableFrom(Object.class) ? (declaredType.isInterface() ? new HashMap().getClass().getConstructor(DEFAULT_PARAMETER_TYPES) : declaredType.getConstructor(DEFAULT_PARAMETER_TYPES)) : preferredType.getConstructor(DEFAULT_PARAMETER_TYPES);
        }
        catch (Exception e) {
            Logger.log(1, "Cannot locate constructor for %s (%s)", preferredType, e.getMessage());
            throw new IllegalStateException(e);
        }
    }

    protected Class<?> getConcreteClass(Type type) {
        if (type instanceof Class) {
            return ((Class)type).isInterface() ? null : (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return this.getConcreteClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            Class<?> componentClass = this.getConcreteClass(componentType);
            return componentClass != null ? Array.newInstance(componentClass, 0).getClass() : null;
        }
        return null;
    }
}

