/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.serialization.fieldserializers;

import com.oracle.coherence.common.logging.Logger;
import com.oracle.coherence.common.serialization.fieldserializers.AbstractGenericFieldSerializer;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;

public final class CollectionFieldSerializer
extends AbstractGenericFieldSerializer {
    public CollectionFieldSerializer(Field field, Class<?> preferredType) {
        super(field, preferredType);
    }

    @Override
    public void readField(Object object, Field field, PofReader reader, int index) throws IllegalArgumentException, IllegalAccessException, IOException {
        Collection collection = (Collection)field.get(object);
        if (collection == null) {
            try {
                collection = (Collection)this.constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                Logger.log(1, "Failed to create a new instance (%s): %s", collection, e.getMessage());
                throw new IllegalStateException(e);
            }
        }
        field.set(object, reader.readCollection(index, collection));
    }

    @Override
    public void writeField(Object object, Field field, PofWriter writer, int index) throws IllegalArgumentException, IOException, IllegalAccessException {
        if (this.typeArguments == null) {
            writer.writeCollection(index, (Collection)field.get(object));
        } else {
            writer.writeCollection(index, (Collection)field.get(object), (Class)this.typeArguments[0]);
        }
    }
}

