/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.serialization.fieldserializers;

import com.oracle.coherence.common.logging.Logger;
import com.oracle.coherence.common.serialization.fieldserializers.AbstractGenericFieldSerializer;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Map;

public final class MapFieldSerializer
extends AbstractGenericFieldSerializer {
    public MapFieldSerializer(Field field, Class<?> preferredType) {
        super(field, preferredType);
    }

    @Override
    public void readField(Object object, Field field, PofReader reader, int index) throws IllegalArgumentException, IllegalAccessException, IOException {
        Map map = (Map)field.get(object);
        if (map == null) {
            try {
                map = (Map)this.constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                Logger.log(1, "Failed to create new instance of a map for %s", field);
                throw new IllegalStateException(e);
            }
        }
        field.set(object, reader.readMap(index, map));
    }

    @Override
    public void writeField(Object object, Field field, PofWriter writer, int index) throws IllegalArgumentException, IOException, IllegalAccessException {
        if (this.typeArguments == null) {
            writer.writeMap(index, (Map)field.get(object));
        } else {
            writer.writeMap(index, (Map)field.get(object), (Class)this.typeArguments[0], (Class)this.typeArguments[1]);
        }
    }
}

